/***************************************************************************
                          smb4kglobal  -  description
                             -------------------
    begin                : Sa Apr 2 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KGLOBAL_H
#define SMB4KGLOBAL_H

#include <qstring.h>
#include <qmap.h>
#include <qtimer.h>

#include <kconfig.h>

#include "smb4kpasswordhandler.h"


/**
 * This is the global namespace for the core classes of Smb4K.
 *
 * @author    Alexander Reinholdt <dustpuppy@mail.berlios.de>
 */

namespace Smb4K_Global
{
  /**
   * This function returns the "global" options for smbclient, i.e. if Kerberos
   * should be used, etc.
   *
   * @returns           A string with the "global" options for nmblookup
   */
  const QString getSmbclientOptions();

  /**
   * This function returns the "global" options for nmblookup, i.e. the domain
   * the client is in, if Kerberos should be used, etc.
   *
   * @returns           A string with the "global" options for nmblookup
   */
  const QString getNmblookupOptions();

  /**
   * Returns the map of global smb.conf options. You can reach the value
   * of each option by providing the lowercase option name as key, if it
   * was defined in the global section of the smb.conf.
   *
   * @returns           A map of the [global] section of the smb.conf
   */
  const QMap<QString, QString> readGlobalSMBOptions();

  /**
   * This function returns the WINS server the system is using.
   *
   * @returns           The name or IP of the WINS server
   */
  const QString getWINSServer();

  /**
   * This function returns the Kernel version string. Vendor specific extension
   * will be ignored. That means the string will look like this '2.6.10' rather
   * than '2.6.10-blabla'. This function is mainly provided for convenience.
   *
   * @returns           The version string of the kernel
   */
  const QString getKernelVersion();

  /**
   * This function returns the system name. It is mainly provided for
   * convenience.
   *
   * @returns           The name of the system
   */
  const QString getSystemName();

  /**
   * This function returns the UMASK as integer. It is provided
   * for convenience.
   *
   * @returns           The UMASK as integer
   */
  int getUMASK();

  /**
   * This function returns the "global" options for the net command.
   * You'll have to provide the command that you want to use to get the
   * right options back.
   *
   * @param command     The command that should be used. It has to be one
   *                    of the following: "share", "share_no_protocol" (same as "share"
   *                    but without protocol), "server domain", "lookup host [HOST]".
   *                    See also the manual page of the net command for more info.
   *
   * @returns           The global 'net' command options
   */
  const QString getNetOptions( const QString &command );

  /**
   * This is the global KConfig object for Smb4K. It points to the configuration
   * stored in $HOME/.kde/share/config/smb4krc.
   *
   * @returns           A pointer to the global KConfig object.
   */
  KConfig *config();

  /**
   * This returns the pointer to the global timer for the application.
   * WARNING: Du *NOT* stop this timer anywhere in the program or all
   * actions that need a timer are stopped all over the application!
   *
   * @returns           A pointer to the global timer.
   */
  QTimer *timer();

  /**
   * This function returns the interval of the timer.
   *
   * @returns           The interval of the timer in msec.
   */
  const int timerInterval();
};

#endif
