/***************************************************************************
    smb4ksystemtray.h  - The widget that handles the docking to the
             system tray.
                             -------------------
    begin                : Mon Jan 12 2004
    copyright            : (C) 2004 by Franck Babin
    email                : babinfranck@yahoo.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KSYSTEMTRAY_H
#define SMB4KSYSTEMTRAY_H

//Qt includes
#include <qvariant.h>
#include <qstringlist.h>

// KDE includes
#include <ksystemtray.h>

// Application includes
#include "../smb4k.h"

/**
 * This class is used in order to manage the window with a system tray icon.
 */
class Smb4KSystemTray : public KSystemTray
{
  Q_OBJECT

public:
  /** The constructor. */
  Smb4KSystemTray(QWidget *parent=0, const char *name=0);
  /** The destructor. */
    ~Smb4KSystemTray();

public slots:
  /**
  * Docks the main widget to the system tray,
  */
  void dock();
  /**
  * Undocks the window from the system tray,
  */
  void undock();

private slots:
  void slotMountedShares();
  void slotMountedShare(Smb4KShare *share);
  void slotUnmountedShare(QString share, QString path);
  void slotUnmountedAllShares();
  void slotDisplayShare(const QVariant &item_id);
  void slotMountBookmark(int id);
  void slotDisplayConfig();

private:
  void initContextMenu();
  void mountShare(const QString name, const QString path);
  bool docked;
  Smb4KApp *m_app;
  enum context_actions {Configure};
  QPopupMenu *popup_shares;
  QPopupMenu *popup_bookmarks;
  /*FIXME only temporary while mounted emit imported for all*/
  QMap<QString, QString> mounted_shares;
  QMap<int, QString> mounted_shares_id;
};

#endif
