/***************************************************************************
    smb4ksharetab.cpp  -  description
                             -------------------
    begin                : Mit Mr 12 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qdir.h>
#include <qregexp.h>
#include <qvaluelist.h>

// KDE includes
#include <klocale.h>
#include <kiconloader.h>

// application specific includes
#include "smb4ksharetab.h"
#include "../smb4k.h"
#include "../core/smb4kuser.h"

Smb4KShareTab::Smb4KShareTab( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  m_current = new Smb4KShare();
  
  QGridLayout *grid = new QGridLayout( this );
  grid->setMargin( 30 );

  QLabel *picLabel = new QLabel( this );
  picLabel->setPixmap( DesktopIcon( "hdd_mount", 32 ) );
  picLabel->setFixedWidth( 64 );
  picLabel->setMargin( 5 );

  QLabel *topLabel = new QLabel( i18n( "<font size=+2><b>Share</b></font>" ), this );

  QFrame *line1 = new QFrame( this );
  line1->setFrameShadow( QFrame::Sunken );
  line1->setFrameShape( QFrame::HLine );

  QSpacerItem *spacer1 = new QSpacerItem( 10, 20, QSizePolicy::Preferred, QSizePolicy::Preferred );

  m_shareLabel = new QLabel( QString::null, this );
  m_share = new KSqueezedTextLabel( QString::null, this );

  m_mountpointLabel = new QLabel( QString::null, this );
  m_mountpoint = new KSqueezedTextLabel( QString::null, this );
  
  m_userLabel = new QLabel( QString::null, this );
  m_user = new KSqueezedTextLabel( QString::null, this );
  
  m_groupLabel = new QLabel( QString::null, this );
  m_group = new KSqueezedTextLabel( QString::null, this );

  QSpacerItem *spacer2 = new QSpacerItem( 10, 20, QSizePolicy::Preferred, QSizePolicy::Preferred );

  m_totalLabel = new QLabel( QString::null, this );
  m_total = new KSqueezedTextLabel( QString::null, this );
  
  m_freeLabel = new QLabel( QString::null, this );
  m_free = new KSqueezedTextLabel( QString::null, this );
  
  m_usedLabel = new QLabel( QString::null, this );
  m_used = new KSqueezedTextLabel( QString::null, this );

  QSpacerItem *spacer3 = new QSpacerItem( 10, 20, QSizePolicy::Preferred, QSizePolicy::Preferred );

  m_usageLabel = new QLabel( QString::null, this );
  m_usage = new KProgress( 100, this );
  m_usage->setMaximumWidth( 100 );
  m_usage->setTextEnabled( true );

  m_contentsLabel = new QLabel( QString::null, this );
  m_contents = new KSqueezedTextLabel( QString::null, this );
  
  QSpacerItem *spacer4 = new QSpacerItem( 10, 10, QSizePolicy::Expanding, QSizePolicy::Expanding );

  grid->addMultiCellWidget( picLabel, 0, 1, 0, 0, 0 );
  grid->addMultiCellWidget( topLabel, 0, 1, 1, 4, 0 );
  grid->addMultiCellWidget( line1, 2, 2, 0, 4, 0 );
  grid->addMultiCell( spacer1, 3, 3, 0, 4, 0 );
  grid->addWidget( m_shareLabel, 4, 1, 0 );
  grid->addMultiCellWidget( m_share, 4, 4, 2, 4, 0 );
  grid->addWidget( m_mountpointLabel, 5, 1, 0 );
  grid->addMultiCellWidget( m_mountpoint, 5, 5, 2, 4, 0 );
  grid->addWidget( m_userLabel, 6, 1, 0 );
  grid->addMultiCellWidget( m_user, 6, 6, 2, 4, 0 );
  grid->addWidget( m_groupLabel, 7, 1, 0 );
  grid->addMultiCellWidget( m_group, 7, 7, 2, 4, 0 );
  grid->addMultiCell( spacer2, 8, 8, 0, 4, 0 );
  grid->addWidget( m_usageLabel, 9, 1, 0 );
  grid->addMultiCellWidget( m_usage, 9, 9, 2, 4, 0 );
  grid->addMultiCell( spacer3, 10, 10, 0, 4 );
  grid->addWidget( m_totalLabel, 11, 1, 0 );
  grid->addMultiCellWidget( m_total, 11, 11, 2, 4, 0 );
  grid->addWidget( m_freeLabel, 12, 1, 0 );
  grid->addMultiCellWidget( m_free, 12, 12, 2, 4, 0 );
  grid->addWidget( m_usedLabel, 13, 1, 0 );
  grid->addMultiCellWidget( m_used, 13, 13, 2, 4, 0 );
  grid->addWidget( m_contentsLabel, 14, 1, 0 );
  grid->addMultiCellWidget( m_contents, 14, 14, 2, 4, 0 );
  grid->addMultiCell( spacer4, 15, 15, 0, 4, 0 );

  connect( sapp->core()->shellIO(), SIGNAL( emptyPath() ),                 this, SLOT( slotClearWidget() ) );
  connect( sapp->core()->shellIO(), SIGNAL( usage( int, int, int, int ) ), this, SLOT( slotUsage( int, int, int, int ) ) );
}


Smb4KShareTab::~Smb4KShareTab()
{
  delete m_current;
}


void Smb4KShareTab::clear()
{
  m_shareLabel->setText( QString::null );
  m_share->setText( QString::null );
  m_mountpointLabel->setText( QString::null );
  m_mountpoint->setText( QString::null );
  m_userLabel->setText( QString::null );
  m_user->setText( QString::null );
  m_groupLabel->setText( QString::null );
  m_group->setText( QString::null );
  m_totalLabel->setText( QString::null );
  m_total->setText( QString::null );
  m_freeLabel->setText( QString::null );
  m_free->setText( QString::null );
  m_usedLabel->setText( QString::null );
  m_used->setText( QString::null );
  m_usageLabel->setText( QString::null );
  m_usage->hide();
  m_contentsLabel->setText( QString::null );
  m_contents->setText( QString::null );
  
  m_current->clear();
}


void Smb4KShareTab::init( Smb4KShare *share )
{
  if ( share && !share->isEmpty() )
    m_current = share;
  else
    clear();
}

/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////


void Smb4KShareTab::slotUsage( int total, int used, int free, int percent )
{
  if ( !m_current->isEmpty() )
  {
    // Show all labels at once.
    m_shareLabel->setText( i18n( "Share:" ) );
    m_mountpointLabel->setText( i18n( "Mount Point:" ) );
    m_userLabel->setText( i18n( "User:" ) );
    m_groupLabel->setText( i18n( "Group:" ) );
    m_usageLabel->setText( i18n( "Usage:" ) );
    m_totalLabel->setText( i18n( "Total:" ) );
    m_freeLabel->setText( i18n( "Free:" ) );
    m_usedLabel->setText( i18n( "Used:" ) );
    m_contentsLabel->setText( i18n( "Contents:" ) );
    
    m_share->setText( m_current->getName() );
    m_mountpoint->setText( m_current->getPath() );
      
    m_user->setText( QString( "%1   (%2)" ).arg( m_current->getUser() ).arg( m_current->getUID() ) );
    m_group->setText( QString( "%1   (%2)" ).arg( m_current->getGroup() ).arg( m_current->getGID() ) );
        
    m_usage->setProgress( percent );
      
    if ( !m_usage->isShown() )
      m_usage->show();
        
    double temp;
    QString dim;
      
    if ( (double)total > 1023 )
    {
      temp = (double)total / 1024;   // MB
      dim = " MB";
        
      if ( temp > 1023 )
      {
        temp = temp / 1024;               // GB
        dim = " GB";
      }
    }
    else
    {
      temp = (double)total;
      dim = " KB";
    }
    m_total->setText( QString( "%1" ).arg( temp, 0, 'f', 2 ). append( dim ).stripWhiteSpace() );
      
    if ( (double)free > 1023 )
    {
      temp = (double)free / 1024;   // MB
      dim = " MB";
        
      if ( temp > 1023 )
      {
        temp = temp / 1024;               // GB
        dim = " GB";
      }
    }
    else
    {
      temp = (double)free;
      dim = " KB";
    }
    m_free->setText( QString( "%1" ).arg( temp, 0, 'f', 2 ).append( dim ).stripWhiteSpace() );  
        
    if ( (double)used > 1023 )
    {
      temp = (double)used / 1024;   // MB
      dim = " MB";
      if ( temp > 1023 )
      {
        temp = temp / 1024;               // GB
        dim = " GB";
      }
    }
    else
    {
      temp = (double)used;
      dim = " KB";
    }
    m_used->setText( QString( "%1" ).arg( temp, 0, 'f', 2 ).append( dim ).stripWhiteSpace() );
      
    // Get the info about the directory.
    QDir *dir = new QDir( m_current->getPath() );
      
    // Substract 2 from all and dirs, because we do not want to count '.' and '..'.
    int all = 0;
    int dirs = 0;
    int files = 0;
    if ( dir->entryList( QDir::All, QDir::DefaultSort ).count() != 0 )
      all = dir->entryList( QDir::All, QDir::DefaultSort ).count() - 2;
    if ( dir->entryList( QDir::Dirs, QDir::DefaultSort ).count() != 0 )
      dirs = dir->entryList( QDir::Dirs, QDir::DefaultSort ).count() - 2;
    files = dir->entryList( QDir::Files, QDir::DefaultSort ).count();
      
    // Assemble the output.
    QString part1, part2, part3, output;
    if ( all == 1 )
      part1 = QString( i18n( "%1 Item   " ) ).arg( all );
    else
      part1 = QString( i18n( "%1 Items   " ) ).arg( all );
    if ( dirs == 1 )
      part2 = QString( i18n( "(%1 Directory, " ) ).arg( dirs );
    else
      part2 = QString( i18n( "(%1 Directories, " ) ).arg( dirs );
    if ( files == 1 )
      part3 = QString( i18n( "%1 File)" ) ).arg( files );
    else
      part3 = QString( i18n( "%1 Files)" ) ).arg( files );
    
    output.append( part1 ).append( part2 ).append( part3 );
    m_contents->setText( output );
  }
  else
    clear();
}


void Smb4KShareTab::slotClearWidget()
{
  clear();
}

#include "smb4ksharetab.moc"
