/***************************************************************************
    smb4kshareoptions  -  description
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>

// KDE includes
#include <klocale.h>

// applications specific includes
#include "smb4kshareoptions.h"
#include "../smb4k.h"

Smb4KShareOptions::Smb4KShareOptions( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );
  grid->setSpacing( 10 );
  
  QVGroupBox *dirBox = new QVGroupBox( i18n( "Directories" ), this );
  QLabel *defaultPathLabel = new QLabel( i18n( "This is the default directory, where Smb4K will mount the SMB shares to. Adjust it according to your wishes." ), dirBox );
  defaultPathLabel->setTextFormat( RichText );
  m_defaultPath = new KURLRequester( QString::null, dirBox );
  m_defaultPath->setMode( KFile::Directory );
  m_cleanUp = new QCheckBox( i18n( "Clean up the default directory on exit." ), dirBox );
  m_lowercase = new QCheckBox( i18n( "Force generated subdirectories to be lower case." ), dirBox );

  QButtonGroup *mountBox = new QButtonGroup( i18n( "Mounting and Unmounting" ), this );
  m_unmountAll = new QCheckBox( i18n( "Unmount all shares on exit." ), mountBox );
  m_unmountAll->setGeometry( 10, 25, m_unmountAll->sizeHint().width(), m_unmountAll->sizeHint().height() );
  m_mountRecent = new QCheckBox( i18n( "Mount recently used shares on start-up." ), mountBox );
  m_mountRecent->setGeometry( 10, m_unmountAll->frameGeometry().bottom()+5, m_mountRecent->sizeHint().width(), m_mountRecent->sizeHint().height() );
  m_allowUnmountForeign = new QCheckBox( i18n( "Allow the unmounting of shares that are owned by other users." ), mountBox );
  m_allowUnmountForeign->setGeometry( 10, m_mountRecent->frameGeometry().bottom()+5, m_allowUnmountForeign->sizeHint().width(), m_allowUnmountForeign->sizeHint().height() );

  QVGroupBox *superBox = new QVGroupBox( i18n( "Super User Privileges" ), this, "SuperBox" );
  m_unmountDead = new QCheckBox( i18n( "Use super user privileges to force the unmounting of (broken) shares.\n(Requires Linux kernel 2.4.11 or later.)" ), superBox );
  m_useSuper = new QCheckBox( i18n( "Use super user privileges to mount and unmount shares." ), superBox );

  QWidget *buttons = new QWidget( superBox );
  QGridLayout *buttonsGrid = new QGridLayout( buttons );
  buttonsGrid->setSpacing( 5 );
  m_removeSUEntries = new KPushButton( i18n( "Remove Entries" ), buttons );
  QSpacerItem *spacer = new QSpacerItem( 5, 5, QSizePolicy::Expanding, QSizePolicy::Preferred );
  buttonsGrid->addWidget( m_removeSUEntries, 0, 1, 0 );
  buttonsGrid->addItem( spacer, 0, 0 );

  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid->addWidget( dirBox, 0, 0, 0 );
  grid->addWidget( mountBox, 1, 0, 0 );
  grid->addWidget( superBox, 2, 0, 0 );
  grid->addItem( spacer2, 3, 0 );

  connect( m_removeSUEntries, SIGNAL( clicked() ), SLOT( slotRemoveClicked() ) );
}

Smb4KShareOptions::~Smb4KShareOptions()
{
}


////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
////////////////////////////////////////////////////////////////////////////

/***************************************************************************
   Is called, when the "Remove Entries" button is clicked.
***************************************************************************/

void Smb4KShareOptions::slotRemoveClicked()
{
  if ( sapp->core()->fileIO()->removeSuperUserEntries() )
  {
    m_unmountDead->setChecked( false );
    m_useSuper->setChecked( false );
  }
}


#include "smb4kshareoptions.moc"
