/***************************************************************************
    smb4ksearchtab.cpp  -  The search widget class.
                             -------------------
    begin                : Son Mai 11 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qiconset.h>

// KDE includes
#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kapplication.h>

// application specific includes
#include "smb4ksearchtab.h"
#include "../smb4k.h"
#include "../core/smb4knetworkitems.h"


Smb4KSearchTab::Smb4KSearchTab( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );
  grid->setMargin( 30 );
  grid->setSpacing( 10 );

  m_input = new KComboBox( QString::null, this );
  m_input->setEditable( true );
  m_input->setFocus();
  m_input->setDuplicatesEnabled( false );
  
  QIconSet searchSet( SmallIcon( "find" ), QIconSet::Automatic );
  m_searchButton = new KPushButton( searchSet, i18n( "S&earch" ), this, 0 );

  QIconSet addSet( SmallIcon( "button_ok" ), QIconSet::Automatic );
  m_addButton = new KPushButton( addSet, i18n( "A&dd" ), this, 0 );

  QIconSet clearAllSet( SmallIcon( "editdelete"  ), QIconSet::Automatic );
  m_clearAllButton = new KPushButton( clearAllSet, i18n( "&Clear" ), this, 0 );

  m_window = new KListBox( this );

  QSpacerItem *spacer = new QSpacerItem( 10, 10, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid->addMultiCellWidget( m_input, 0, 0, 0, 7 );
  grid->addWidget( m_searchButton, 0, 8 );
  grid->addMultiCellWidget( m_window, 1, 3, 0, 7 );
  grid->addWidget( m_addButton, 1, 8 );
  grid->addWidget( m_clearAllButton, 2, 8 );
  grid->addItem( spacer, 3, 8 );

  // Internal connections
  connect( m_searchButton, SIGNAL( clicked() ), SLOT( slotSearchClicked() ) );
  connect( m_addButton, SIGNAL( clicked() ), SLOT( slotAddClicked() ) );
  connect( m_clearAllButton, SIGNAL( clicked() ), SLOT( slotClearAllClicked() ) );
  connect( m_input, SIGNAL( returnPressed() ), SLOT( slotSearchClicked() ) );
  connect( m_window, SIGNAL( highlighted( const QString & ) ), SLOT( slotItemHighlighted( const QString & ) ) );
  
  // External connections
  connect( sapp->core()->scanner(), SIGNAL( searchResult( Smb4KHostItem * ) ), this, SLOT( slotReceivedSearchResult( Smb4KHostItem * ) ) );
//  connect( m_window, SIGNAL( executed( QListBoxItem * ) ), this, SLOT( slotItemExecuted( QListBoxItem * ) ) );
}


Smb4KSearchTab::~Smb4KSearchTab()
{
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSearchTab::slotSearchClicked()
{
  // The user should be able to search for an IP address as well.
  // But since smbclient is not useful for this, the user won't be able
  // to do a search, if he/she entered and IP address and uses smbclient.
  if ( m_input->currentText().stripWhiteSpace().contains( '.', true ) != 3 )
  {
    if ( m_input->currentText().stripWhiteSpace().length() != 0 )
    {
      sapp->core()->scanner()->makeSearch( m_input->currentText() );
      // Put the search string (the share name) into its variable. It is to
      // be upper case.
      m_host = m_input->currentText().upper();
      // The edit line of the combobox has to be cleaned.
      m_input->clearEdit();
    }
  }
  else
  {
    kapp->config()->setGroup( "Browse Options" );

    if ( kapp->config()->readEntry( "Network Search", "nmblookup" ) == "smbclient" )
      KMessageBox::sorry( this, i18n( "The search method you chose (smbclient) can't handle IP addresses correctly. Please choose \"Use nmblookup.\" in the configuration dialog and try again." ) );
    else
    {
      if ( m_input->currentText().stripWhiteSpace().length() != 0 )
      {
        sapp->core()->scanner()->makeSearch( m_input->currentText() );
        m_host = m_input->currentText().upper();
        m_input->clearEdit();
      }
    }
  }
}


void Smb4KSearchTab::slotAddClicked()
{
  if ( m_itemText.length() != 0 )
  {
    QString host = m_itemText.section( " ", 0, 0 ).stripWhiteSpace();
    QString ip = m_itemText.section( "(", 1, 1 ).section( ")", 0, 0 );
    QString workgroup = m_itemText.section( "[", 1, 1 ).section( "]", 0, 0 );
    
    if ( workgroup.length() != 0 )
      sapp->view()->networkView()->insertItem( new Smb4KHostItem( workgroup, host, QString::null, ip ) );
    else
      KMessageBox::sorry( this, i18n( "Can't add this share! The workgroup is missing." ), QString::null, KMessageBox::Notify );
  }
}


void Smb4KSearchTab::slotClearAllClicked()
{
  m_input->clear();
  m_window->clear();
  m_itemText = QString::null;
}


void Smb4KSearchTab::slotItemHighlighted( const QString &text )
{
  if ( !text.contains( i18n( "could not be found." ) ) )
    m_itemText = text;
  else
    m_itemText = QString::null;
}


void Smb4KSearchTab::slotReceivedSearchResult( Smb4KHostItem *item )
{
  // Did the search fail?
  if ( item->workgroup().isEmpty() && item->name().isEmpty() && item->ip().isEmpty() )
  {
    QString entry = QString( i18n( "The search for %1 failed." ) ).arg( m_host );
    m_window->insertItem( SmallIcon( "no" ), entry, 0 );
  }
  // If the search did not fail:
  else
  {
    QString entry( item->name() );
    entry.append( " (" ).append( item->ip() ).append( ")" );    
    entry.append( " [" ).append( item->workgroup() ).append( "]" );
    m_window->insertItem( SmallIcon( "network_local" ), entry, 0 );
  }
}

#include "smb4ksearchtab.moc"
