/***************************************************************************
    smb4ksambaoptions.cpp  -  description
                             -------------------
    begin                : Mo Jan 26 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qhbuttongroup.h>
#include <qtabwidget.h>

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4ksambaoptions.h"


Smb4KSambaOptions::Smb4KSambaOptions( QWidget *parent, const char *name ) : QTabWidget( parent, name )
{
  setMargin( 10 );
  
  //
  // The tab for general options.
  //
  QWidget *tab1 = new QWidget( this, "SambaGeneralTab" );
  QGridLayout *grid1 = new QGridLayout( tab1 );
  grid1->setSpacing( 10 );

  QGroupBox *box1 = new QGroupBox( 1, Qt::Horizontal, i18n( "General Options" ), tab1 );
  box1->setInsideSpacing( 10 );

  QWidget *w1 = new QWidget( box1 );
  QGridLayout *w1grid = new QGridLayout( w1 );
  w1grid->setSpacing( 10 );

  QLabel *netbiosLabel = new QLabel( i18n( "NetBIOS name:" ), w1 );
  m_netbios = new KLineEdit( QString::null, w1 );

  QLabel *sockoptLabel = new QLabel( i18n( "Socket options:" ), w1 );
  m_sockopt = new KLineEdit( QString::null, w1 );

  QLabel *scopeLabel = new QLabel( i18n( "Scope (Read manual page first!):" ), w1 );
  m_scope = new KLineEdit( QString::null, w1 );

  QLabel *portLabel = new QLabel( i18n( "Remote SMB port:" ), w1 );
  m_port = new KIntNumInput( 139, w1 );
  // Set the port range:
  m_port->setMinValue( 0 );
  m_port->setMaxValue( 65535 );

  w1grid->addWidget( netbiosLabel, 0, 0, 0 );
  w1grid->addWidget( m_netbios, 0, 1, 0 );
  w1grid->addWidget( sockoptLabel, 1, 0, 0 );
  w1grid->addWidget( m_sockopt, 1, 1, 0 );
  w1grid->addWidget( scopeLabel, 2, 0, 0 );
  w1grid->addWidget( m_scope, 2, 1, 0 );
  w1grid->addWidget( portLabel, 3, 0, 0 );
  w1grid->addWidget( m_port, 3, 1, 0 );

  m_krb = new QCheckBox( i18n( "Use Kerberos (Active Directory)." ), box1 );
  m_krb->setGeometry( 10, scopeLabel->frameGeometry().bottom()+10, m_krb->sizeHint().width(), m_krb->sizeHint().height() );
  
  QSpacerItem *spacer1 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );
  
  grid1->addWidget( box1, 0, 0, 0 );
  grid1->addItem( spacer1, 1, 0 );
  
  addTab( tab1, i18n( "General" ) );

  
  //
  // Tab for smbmount options.
  //
  QWidget *w2 = new QWidget( this, "SambaSmbmountTab" );
  QGridLayout *w2grid = new QGridLayout( w2 );
  w2grid->setSpacing( 10 );

  QGroupBox *w2box1 = new QGroupBox( 2, Qt::Horizontal, i18n( "User and Group" ), w2 );
  w2box1->setInsideSpacing( 10 );
  w2box1->setInsideMargin( 10 );
  
  QLabel *uidLabel = new QLabel( w2box1 );
  uidLabel->setText( i18n( "Set the UID to:" ) );
  m_uid = new KComboBox( w2box1 );
  m_uid->insertItem( i18n( "default" ) );
  QLabel *gidLabel = new QLabel( w2box1 );
  gidLabel->setText( i18n( "Set the GID to:" ) );
  m_gid = new KComboBox( w2box1 );
  m_gid->insertItem( i18n( "default" ) );

  QGroupBox *w2box2 = new QGroupBox( 1, Qt::Horizontal, i18n( "Permissions" ), w2 );
  w2box2->setInsideSpacing( 10 );

  QWidget *w2w1 = new QWidget( w2box2 );
  QGridLayout *w2w1grid = new QGridLayout( w2w1 );
  w2w1grid->setSpacing( 10 );
  QLabel *fmaskLabel = new QLabel( i18n( "File mask for remote files:" ), w2w1 );
  m_fmask = new KLineEdit( QString::null, w2w1 );
  m_fmask->setAlignment( Qt::AlignRight );
  QLabel *dmaskLabel = new QLabel( i18n( "Directory mask:" ), w2w1 );
  m_dmask = new KLineEdit( QString::null, w2w1 );
  m_dmask->setAlignment( Qt::AlignRight );
  QLabel *rwLabel = new QLabel( w2w1 );
  rwLabel->setText( i18n( "Mount shares:" ) );
  QHButtonGroup *bg1 = new QHButtonGroup( w2w1 );
  bg1->setInsideMargin( 0 );
  bg1->setLineWidth( 0 );
  m_rw = new QRadioButton( i18n( "read-write" ), bg1 );
  m_ro = new QRadioButton( i18n( "read-only" ), bg1 );    
  w2w1grid->addWidget( fmaskLabel, 0, 0, 0 );
  w2w1grid->addWidget( m_fmask, 0, 1, 0 );
  w2w1grid->addWidget( dmaskLabel, 1, 0, 0 );
  w2w1grid->addWidget( m_dmask, 1, 1, 0 );
  w2w1grid->addWidget( rwLabel, 2, 0, 0 );
  w2w1grid->addWidget( bg1, 2, 1, 0 );

  QGroupBox *w2box3 = new QGroupBox( 2, Qt::Horizontal, i18n( "Charset and Codepage" ), w2 );
  w2box3->setInsideSpacing( 10 );

  QLabel *charLabel = new QLabel( w2box3 );
  charLabel->setText( i18n( "Linux charset:" ) );
  m_charset = new KComboBox( w2box3 );
  QStringList charsets;
  charsets << "iso8859-1" << "iso8859-2" << "iso8859-3" << "iso8859-4" << "iso8859-5" << "iso8859-6" << "iso8859-7" << "iso8859-8" << "iso8859-9" << "iso8859-13" << "iso8859-14" << "iso8859-15" << "koi8-r" << "koi8-u" << "koi8-ru" << "utf8" << "gb2312" << "big5" << "euc-jp" << "euc-kr" << "tis-620";
  charsets.sort();
  m_charset->insertItem( i18n( "default" ) );
  m_charset->insertStringList( charsets );

  QLabel *cpLabel = new QLabel( w2box3 );
  cpLabel->setText( i18n( "Server codepage:" ) );
  m_codepage = new KComboBox( w2box3 );
  QStringList codepages;
  codepages << "cp437" << "cp737" << "cp775" << "cp850" << "cp852" << "cp855" << "cp857" << "cp860" << "cp861" << "cp862" << "cp863" << "cp864" << "cp865" << "cp866" << "cp869" << "cp936" << "cp950" << "cp932" << "cp874" << "cp1255" << "cp1250" << "cp1251" << "cp1252" << "cp1253" << "cp1254" << "cp1256" << "cp1257" << "cp1258" << "cp949" << "cp932" << "cp720" << "cp858";
  codepages.sort();
  m_codepage->insertItem( i18n( "default" ) );
  m_codepage->insertStringList( codepages );


  QGroupBox *w2box4 = new QGroupBox( 1, Qt::Horizontal, i18n( "Miscellaneous" ), w2 );
  
  QWidget *w2w2 = new QWidget( w2box4 );
  QGridLayout *w2w2grid = new QGridLayout( w2w2 );
  w2w2grid->setSpacing( 10 );
  QLabel *ttlLabel = new QLabel( i18n( "Caching time of directory listings:" ), w2w2 );
  m_ttl = new KIntNumInput( 1000, w2w2 );
  m_ttl->setSuffix( " ms" );
  m_ttl->setMinValue( 0 );
  w2w2grid->addWidget( ttlLabel, 0, 0, 0 );
  w2w2grid->addWidget( m_ttl, 0, 1, 0 );
  m_unicode = new QCheckBox( i18n( "Use unicode when communicating with the server." ), w2box4 );
  m_lfs = new QCheckBox( i18n( "Use large filesystem support." ), w2box4 );
  
  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  w2grid->addWidget( w2box1, 0, 0, 0 );
  w2grid->addMultiCellWidget( w2box2, 1, 1, 0, 1, 0 );
  w2grid->addWidget( w2box3, 0, 1, 0 );
  w2grid->addMultiCellWidget( w2box4, 2, 2, 0, 1, 0 );
  w2grid->addMultiCell( spacer2, 3, 3, 0, 1 );

  addTab( w2, "smbmount" );

  //
  // Tab for smbclient options.
  //
  QWidget *w3 = new QWidget( this, "SambaSmbclientTab" );
  QGridLayout *w3grid = new QGridLayout( w3 );
  w3grid->setSpacing( 10 );

  QGroupBox *w3box1 = new QGroupBox( 2, Qt::Horizontal, i18n( "Miscellaneous" ), w3 );
  w3box1->setInsideSpacing( 10 );

  QLabel *resolveLabel = new QLabel( w3box1 );
  resolveLabel->setText( i18n( "Resolve order:" ) );
  m_resolve = new KLineEdit( QString::null, w3box1 );

  QLabel *bufferLabel = new QLabel( w3box1 );
  bufferLabel->setText( i18n( "Buffer size:" ) );
  m_buffer = new KIntNumInput( w3box1 );
  m_buffer->setMinValue( 0 );
  m_buffer->setValue( 65520 );
  m_buffer->setSuffix( " Bytes" );
  
  QSpacerItem *spacer3 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  w3grid->addWidget( w3box1, 0, 0, 0 );  
  w3grid->addItem( spacer3, 1, 0 );
  
  addTab( w3, "smbclient" );
  
  //
  // Tab for nmblookup options.
  //
  QWidget *w4 = new QWidget( this, "SambaNmblookupTab" );
  QGridLayout *w4grid = new QGridLayout( w4 );
  w4grid->setSpacing( 10 );
  
  QGroupBox *w4box1 = new QGroupBox( 1, Qt::Horizontal, i18n( "Miscellaneous" ), w4 );
  w4box1->setInsideSpacing( 10 );

  QWidget *w4w1 = new QWidget( w4box1 );
  QGridLayout *w4w1g = new QGridLayout( w4w1 );
  w4w1g->setSpacing( 10 );
    
  QLabel *domainLabel = new QLabel( w4w1 );
  domainLabel->setText( i18n( "SMB domain (workgroup):" ) );
  m_domain = new KLineEdit( QString::null, w4w1 );

  QLabel *broadcastLabel = new QLabel( w4w1 );
  broadcastLabel->setText( i18n( "Broadcast address:" ) );
  m_broadcast = new KLineEdit( QString::null, w4w1 );
    
  w4w1g->addWidget( domainLabel, 0, 0, 0 );
  w4w1g->addWidget( m_domain, 0, 1, 0 );
  w4w1g->addWidget( broadcastLabel, 1, 0, 0 );
  w4w1g->addWidget( m_broadcast, 1, 1, 0 );
  
  m_udp = new QCheckBox( i18n( "Try and bind to UDP port 137 to send and receive UDP datagrams." ), w4box1 );
  
  QSpacerItem *spacer4 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );
  
  w4grid->addWidget( w4box1, 0, 0, 0 );
  w4grid->addItem( spacer4, 1, 0 );  
  
  addTab( w4, "nmblookup" );
}


Smb4KSambaOptions::~ Smb4KSambaOptions()
{
}


#include "smb4ksambaoptions.moc"
