/***************************************************************************
    smb4kbookmarkmenuwidget.h  - A bookmark popup menu.
                             -------------------
    begin                : Feb 04 2004
    copyright            : (C) 2004 by Franck Babin
    email                : babinfranck@yahoo.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SMB4KBOOKMARKMENUWIDGET_H
#define SMB4KBOOKMARKMENUWIDGET_H

// Qt includes
#include <qstringlist.h>

// KDE includes
#include <kpopupmenu.h>
#include <kaction.h>

// Application includes
#include "../smb4k.h"
#include "../core/smb4kshare.h"

/**
 * Popup menu for the list of bookmarks on samba share/
 */
class Smb4KBookmarkMenuWidget : public KPopupMenu
{
Q_OBJECT
public:
  Smb4KBookmarkMenuWidget(int display_mode, QWidget *parent = 0, const char *name = 0);
  ~Smb4KBookmarkMenuWidget();

  enum MODE{FULL, SMALL};

private slots:
  void slotBookmarksUpdated();
  void slotActivated(int id);

  void slotMountedShares();
  void slotMountedShare(Smb4KShare *share);
  void slotUnmountedShare(QString share);
  void slotUnmountedAllShares();
  
private:
  Smb4KApp *m_app;
  void initMenu();
  void initActions();
  void enableBookmark(const QString path, bool enabled);
  int m_display_mode;
};

#endif
