/***************************************************************************
    smb4kshellio  -  This class takes care of all shell IO operations, 
    that are not connected to mounting and unmounting of shares or
    network operations.
                             -------------------
    begin                : Sa Mai 29 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qstringlist.h>
 
// KDE includes
#include <kprocess.h>
 
// application specific includes
#include "smb4kshellio.h"

Smb4KShellIO::Smb4KShellIO( QObject *parent, const char *name ) : QObject( parent, name )
{
  m_timer1 = new QTimer( this );
  m_timer1->start( 1000, false );
  
  m_timer2 = new QTimer( this );
  m_timer2->start( 50, false );
  
  m_queue.setAutoDelete( true );

  m_proc = new KProcess( this );
  m_proc->setUseShell( true );  
  
  connect( m_timer1, SIGNAL( timeout() ),                                 this, SLOT( slotFillQueue() ) );
  connect( m_timer2, SIGNAL( timeout() ),                                 this, SLOT( slotProcess() ) );
  connect( m_proc,   SIGNAL( processExited( KProcess * ) ),               this, SLOT( slotProcessExited( KProcess* ) ) );
  connect( m_proc,   SIGNAL( receivedStdout( KProcess *, char *, int ) ), this, SLOT( slotOutput( KProcess *, char *, int ) ) );
}


Smb4KShellIO::~Smb4KShellIO()
{
  delete m_queue;
}


/****************************************************************************
   Gets the disk usage of a share.
****************************************************************************/

void Smb4KShellIO::getDiskUsage( const QString &path )
{
  if ( !path.isEmpty() )
  {
    m_df_path = path;
    m_queue.enqueue( new QString( QString( "%1:" ).arg( Usage )+"df -P -k "+KProcess::quote( m_df_path ) ) );
  }
  else
  {
    m_df_path = QString::null;
    emit emptyPath();
  }
}


/****************************************************************************
   Processes the output of 'df'.
****************************************************************************/

void Smb4KShellIO::processUsage()
{
  QStringList list = QStringList::split( " ", QStringList::split( '\n', m_buffer, false ).grep( "//" ).first(), false );
  
  if ( !list.isEmpty() )
  {
    QString tmp = list[list.count()-2];
    tmp.truncate( tmp.length() - 1 );
    int percent = tmp.toInt();
    
    emit usage( list[list.count()-5].stripWhiteSpace().toInt(), list[list.count()-4].stripWhiteSpace().toInt(), list[list.count()-3].stripWhiteSpace().toInt(), percent );
  }
}


/////////////////////////////////////////////////////////////////////////////
//   SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KShellIO::slotFillQueue()
{
  if ( m_queue.isEmpty() )
  {
    if ( !m_df_path.isEmpty() )
    {
      m_queue.enqueue( new QString( QString( "%1:" ).arg( Usage )+"df -P -k "+KProcess::quote( m_df_path ) ) );
    }
  }
}


void Smb4KShellIO::slotProcess()
{
  if ( !m_queue.isEmpty() && !m_proc->isRunning() )
  {
    QString *entry = m_queue.dequeue();
    
    m_state = entry->section( ":", 0, 0 ).toInt();
    QString command = entry->section( ":", 1, 1 );
    
    *m_proc << command;
    
    m_proc->start( KProcess::NotifyOnExit, KProcess::Stdout );
  }
}


void Smb4KShellIO::slotOutput( KProcess *, char *buf, int len )
{
  m_buffer.append( QString::fromLocal8Bit( buf, len ) );   
}


void Smb4KShellIO::slotProcessExited( KProcess * )
{
  switch ( m_state )
  {
    case Usage:
      processUsage();
      break;
    default:
      break;
  }
  
  m_proc->clearArguments();
  m_buffer = QString::null;
}

#include "smb4kshellio.moc"
