/***************************************************************************
                          smb4kbookmarkhandler  -  description
                             -------------------
    begin                : Fr Jan 9 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qptrlist.h>

// KDE includes
#include <klocale.h>
#include <kstandarddirs.h>
#include <kdialogbase.h>
#include <kiconloader.h>
#include <kapplication.h>
#include <kpopupmenu.h>

// application specific includes
#include "smb4kbookmarkhandler.h"


Smb4KBookmarkHandler::Smb4KBookmarkHandler( QObject *parent, const char *name ) : QObject( parent, name )
{
  // First we need the directory.
  KStandardDirs *stddir = new KStandardDirs();
  QString dir = locateLocal( "appdata", QString::null, KGlobal::instance() );
  if ( !stddir->exists( dir ) )
    stddir->makeDir( dir );

  // Do not use the KConfig object, that is provided by kapp->config().
  // We want a separate one for the passwords.
  m_config = new KConfig( "bookmarks", false, true, "appdata" );

  m_num = 0;

  // Count the number of entries:
  if ( m_config->hasGroup( "Bookmarks" ) )
  {
    m_config->setGroup( "Bookmarks" );
    for ( int index = 0; ; index++ )
    {
      if ( !m_config->readEntry( QString( "%1" ).arg( index ), QString::null ).isEmpty() )
        m_num++;
      else
        break;
    }
  }

  loadBookmarks();
}

Smb4KBookmarkHandler::~Smb4KBookmarkHandler()
{
  for ( QValueList<Smb4KBookmark *>::Iterator it = m_bookmarks.begin(); it != m_bookmarks.end(); ++it )
    delete *it;
}

/****************************************************************************
   Writes the bookmark to the bookmark file.
****************************************************************************/

void Smb4KBookmarkHandler::writeBookmark( const QString &host, const QString &share )
{
  m_config->setGroup( "Bookmarks" );

  QString bookmark = QString( "//%1/%2" ).arg( host ).arg( share );

  for ( QValueList<Smb4KBookmark *>::ConstIterator it = m_bookmarks.begin(); it != m_bookmarks.end(); ++it )
  {
    if( (*it)->getShare() == bookmark )
    {
      //already exists
      return;
    }
  }

  m_bookmarks.append( new Smb4KBookmark(bookmark) );

  m_config->writeEntry( QString( "%1" ).arg( m_num++ ), bookmark );

  m_config->sync();

  qHeapSort( m_bookmarks.end(), m_bookmarks.begin() );
  
  emit bookmarksUpdated();
}


/****************************************************************************
   Load the bookmarks.
****************************************************************************/

void Smb4KBookmarkHandler::loadBookmarks()
{
  m_config->setGroup( "Bookmarks" );

  for ( int index = 0; ; index++ )
  {
    if ( !m_config->readEntry( QString( "%1" ).arg( index ), QString::null ).isEmpty() )
    {
      QString share(m_config->readEntry( QString( "%1" ).arg( index ), QString::null ));
      m_bookmarks.append( new Smb4KBookmark(share) );
    }
    else
      break;
  }

  qHeapSort( m_bookmarks.end(), m_bookmarks.begin() );
  emit bookmarksUpdated();
}

/****************************************************************************
   Invokes the bookmark editor.
****************************************************************************/

void Smb4KBookmarkHandler::editBookmarks( QWidget *parent, const char *name )
{
  m_editDlg = new KDialogBase( KDialogBase::Plain, i18n( "Bookmark Editor" ), KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, parent, name, false, true );

  QFrame *frame = m_editDlg->plainPage();
  QGridLayout *layout = new QGridLayout( frame );
  layout->setSpacing( 5 );

  m_bmView = new KListView( frame );
  m_bmView->addColumn( i18n( "Bookmarks" ), -1 );
  m_bmView->setResizeMode( QListView::LastColumn );

  for ( QValueList<Smb4KBookmark *>::ConstIterator it = m_bookmarks.begin(); it != m_bookmarks.end(); ++it )
  {
    QListViewItem *item = new QListViewItem( m_bmView, (*it)->getShare() );
    item->setPixmap( 0, SmallIcon( "folder_green" ) );
  }

  layout->addWidget( m_bmView, 0, 0, 0 );

  kapp->config()->setGroup( "General Options" );
  m_editDlg->setInitialSize( kapp->config()->readSizeEntry( "Bookmark Editor Geometry", 0L ) );

  connect( m_editDlg, SIGNAL( okClicked() ), SLOT( slotOKClicked() ) );
  connect( m_bmView, SIGNAL( rightButtonPressed( QListViewItem *, const QPoint &, int ) ), SLOT( slotRightButtonPressed( QListViewItem *, const QPoint &, int ) ) );

  m_editDlg->show();
}

/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KBookmarkHandler::slotOKClicked()
{
  // Save the size of the dialog.
  kapp->config()->setGroup( "General Options" );
  kapp->config()->writeEntry( "Bookmark Editor Geometry", m_editDlg->size() );

  // Write the remaining bookmarks to the bookmark file.
  m_num = 0;
  m_config->deleteGroup( "Bookmarks" );
  m_config->sync();

  for ( QListViewItem *item = m_bmView->firstChild(); ; item = item->nextSibling() )
  {
    if ( item )
      writeBookmark( item->text( 0 ).section( "/", 2, 2 ), item->text( 0 ).section( "/", 3, 3 ) );
    else
      break;
  }
}


void Smb4KBookmarkHandler::slotRightButtonPressed( QListViewItem *item, const QPoint &pos, int col )
{
  // FIXME: Put the popup menu here. Do also add a shortcut "DELETE" to the
  // remove button.
  KPopupMenu *menu = new KPopupMenu( m_bmView );

  QIconSet removeSet( SmallIcon( "remove" ), QIconSet::Automatic );
  menu->insertItem( removeSet, i18n( "Remove" ), this, SLOT( slotRemoveClicked() ), Key_Delete, 0, 0 );

  QIconSet deleteAllSet( SmallIcon( "editdelete" ), QIconSet::Automatic );
  menu->insertItem( deleteAllSet, i18n( "Remove All" ), this, SLOT( slotRemoveAllClicked() ), CTRL+Key_X, 1, 1 );

  if ( item )
    menu->setItemEnabled( 0, true );
  else
    menu->setItemEnabled( 0, false );

  if ( m_bmView->childCount() == 0 )
    menu->setItemEnabled( 1, false );

  menu->exec( pos, col );
}


void Smb4KBookmarkHandler::slotRemoveClicked()
{
  if ( m_bmView->currentItem() )
  {
    QString share = m_bmView->currentItem()->text(0);
    
    for ( QValueList<Smb4KBookmark *>::Iterator it = m_bookmarks.begin(); it != m_bookmarks.end(); ++it )
    {
      if( share == (*it)->getShare())
      {
        m_bookmarks.remove(*it);
        break;
      }
    }
    emit bookmarksUpdated();

    delete m_bmView->currentItem();
    m_bmView->sort();
  }
}


void Smb4KBookmarkHandler::slotRemoveAllClicked()
{
  m_bmView->clear();
  m_bookmarks.clear();  
  emit bookmarksUpdated();
}

#include "smb4kbookmarkhandler.moc"
