/***************************************************************************
    smb4kscanner_p  -  This is a private helper class for Smb4KScanner.
                             -------------------
    begin                : Do Jul 19 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// application specific includes
#include "smb4kscanner_p.h"


Smb4KScannerPrivate::Smb4KScannerPrivate()
{
  retry = false;
  clearData();
}


Smb4KScannerPrivate::~Smb4KScannerPrivate()
{
}


void Smb4KScannerPrivate::clearData()
{
  m_workgroup = Smb4KWorkgroup();
  m_host = Smb4KHost();
}


void Smb4KScannerPrivate::setWorkgroup( const Smb4KWorkgroup &workgroup )
{
  m_workgroup = workgroup;
}


void Smb4KScannerPrivate::setHost( const Smb4KHost &host )
{
  m_host = host;
}


Smb4KScannerQueueContainer::Smb4KScannerQueueContainer( int todo, const Smb4KWorkgroup &wg )
: m_todo( todo ), m_workgroup( wg )
{
}


Smb4KScannerQueueContainer::Smb4KScannerQueueContainer( int todo, const Smb4KHost &item )
: m_todo( todo ), m_host( item )
{
}


Smb4KScannerQueueContainer::Smb4KScannerQueueContainer( int todo, const QString &string )
: m_todo( todo ), m_string( string )
{
}


Smb4KScannerQueueContainer::Smb4KScannerQueueContainer( int todo )
: m_todo( todo )
{
}


Smb4KScannerQueueContainer::~Smb4KScannerQueueContainer()
{
}
