-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class SWITCH_SITE
	--
	-- To memorize all the information about one switch site
	--

insert
	GLOBALS

creation {SWITCH_COLLECTION}
	make

feature {ANY}
	current_type: TYPE
			-- Static type of the target.

	feature_name: FEATURE_NAME
			-- The name of the called feature.

	result_type: TYPE
			-- If any, the `result_type'.

	arguments: FORMAL_ARG_LIST
			-- Of the called feature.

	id: INTEGER
			-- Used to compute the offset in the profile array (used only in profile mode).

	has (rf: RUN_FEATURE): BOOLEAN is
		require
			rf /= Void
		do
			Result := features.fast_has(rf)
		end

	item (i: INTEGER): RUN_FEATURE is
		require
			i.in_range(1, count)
		do
			Result := features.item(i - 1)
		end

	count: INTEGER is
		do
			Result := features.count
		end

feature {SWITCH_COLLECTION}
	add (rf: RUN_FEATURE) is
		require
			not has(rf)
			rf.result_type /= Void xor result_type = Void
		do
			check
				insert_sorted: not features.is_empty implies features.last.type_of_current.live_type.id < rf.type_of_current.live_type.id
			end
			features.add_last(rf)
		end

feature {SWITCH_TYPE}
	jvm_define is
			-- The `Result' is the number of switches.
		local
			up_rf: RUN_FEATURE; switch: SWITCH
		do
			up_rf := current_type.live_type.at(feature_name)
			jvm.set_current_frame(up_rf)
			switch.jvm_define (up_rf) 
		end

feature {}
	make (fn: FEATURE_NAME; ct, rt: TYPE; arg: FORMAL_ARG_LIST) is
		require
			fn /= Void
			ct /= Void
		do
			feature_name := fn
			current_type := ct
			result_type := rt
			arguments := arg
			id := switch_collection.new_id
			create features.with_capacity(4)
		end

	features: FAST_ARRAY[RUN_FEATURE]
			-- The set of possible feature.

invariant
	feature_name /= Void

	current_type /= Void

end -- class SWITCH_SITE
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
