-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class EXCEPTIONS_HANDLER
	--
	-- Unique global object in charge of EXCEPTION handling.
	--

insert
	GLOBALS

creation {ANY}
	make

feature {ANY}
	used: BOOLEAN
			-- Indicate wheter the live code uses EXCEPTIONS or not.

feature {INSPECT_STATEMENT, MANIFEST_STRING_INSPECTOR}
	bad_inspect_value (p: POSITION) is
			-- When some Eiffel "inspect" instruction without the optional "else" part does not match the input.
		require
			cpp.pending_c_function
			ace.no_check
		do
			if used then
				cpp.pending_c_function_body.append(once "internal_exception_handler(Incorrect_inspect_value);%N")
			else
				cpp.pending_c_function_body.append(once "error1(%"Invalid inspect (nothing selected).%",")
				cpp.put_position(p)
				cpp.pending_c_function_body.append(once ");%N")
			end
		end

feature {RUN_FEATURE, EXTERNAL_ROUTINE}
	set_used is
		do
			used := True
		end

feature {C_PRETTY_PRINTER}
	customize_c_runtime is
		do
			if used then
				cpp.sys_runtime_h_and_c(once "exceptions")
			end
		end

	initialize_runtime is
		do
			if used then
				cpp.pending_c_function_body.append(once "setup_signal_handler();%N")
			end
		end

	se_evobt is
		require
			ace.boost
		do
			if used then
				cpp.pending_c_function_body.append(once "internal_exception_handler(Void_call_target)")
			else
				cpp.pending_c_function_body.append(once "se_print_run_time_stack(),exit(1)")
			end
		end

feature {}
	make is
		do
		end

end -- class EXCEPTIONS_HANDLER
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
