-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class EIFFELDOC_COMMENT_STATE_IN_BOLD
	--
	-- Handle '''bold text''' (in triple quotes)
	--

inherit
	EIFFELDOC_COMMENT_STATE

creation {EIFFELDOC_CONTEXT}
	make

feature {EIFFELDOC_COMMENT_WRITER, EIFFELDOC_COMMENT_STATE}
	can_handle (comment: STRING; offset: INTEGER): BOOLEAN is
		do
			Result := offset < comment.count - 3 and then comment.item(offset) = '%'' and then comment.item(offset + 1) = '%'' and then comment.item(offset + 2) = '%''
		end

	handle (comment: STRING; offset: INTEGER; for_feature: ANONYMOUS_FEATURE; states: STACK[EIFFELDOC_COMMENT_STATE]): INTEGER is
		do
			if not states.is_empty and then states.top = Current then
				html.close_bold
				states.pop
			else
				html.with_attribute(once "class", once "wiki_bold")
				html.open_bold
				states.push(Current)
			end
			Result := offset + 3
		end

	abort (states: STACK[EIFFELDOC_COMMENT_STATE]) is
		do
			html.close_bold
			states.pop
		end

	handle_first: BOOLEAN is True

feature {}
	make (a_context: like context) is
		require
			a_context /= Void
		do
			context := a_context
		end

end -- class EIFFELDOC_COMMENT_STATE_IN_BOLD
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
