class UNIVERSE

inherit
	CLUSTERS

insert
	SINGLETON

create {CLASSES_TREE_FACTORY}
	make

feature {ANY}
	to_string: STRING is "Universe"

feature {ACE}
	add_entry (a_distance: INTEGER; system_path, path, name: STRING) is
		require
			a_distance > 0
			name /= Void
			string_aliaser.registered_one(name)
			path /= Void
			is_classes_path(path)
			string_aliaser.registered_one(path)
			system_path /= Void implies is_system_path(system_path)
		local
			factory: CLASSES_TREE_FACTORY; classes: CLASSES
		do
			classes := factory.classes(a_distance, system_path, path, name, Void)
			if classes /= Void and then classes.parent = Void then
				add_classes(classes)
			end
		end

feature {CLASSES_TREE_FACTORY}
	has_physical_cluster (system_path: STRING): BOOLEAN is
		do
			Result := find_physical_cluster(system_path) /= Void
		end

feature {}
	make is
		do
			create classeses.with_capacity(4)
		end

	show_name is
		do
			echo.put_string(once "<Universe>")
		end

invariant
	distance = 0
	parent = Void

end
