-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class TEST_NUMBER74
	-- test on gcd

insert
	NUMBER_TOOLS

creation {ANY}
	make

feature {ANY}
	make is
		local
			n1, n2: NUMBER
		do
			n1 := from_integer(1)
			n2 := from_integer(1)
			assert(n1.gcd(n2) @= 1)
			n1 := from_integer(9)
			n2 := from_integer(12)
			assert(n1.gcd(n2) @= 3)
			n1 := from_integer(36)
			n2 := from_integer(42)
			assert(n1.gcd(n2) @= 6)
			n1 := from_integer(1024)
			n2 := from_integer(3072)
			assert(n1.gcd(n2) @= 1024)
		end

	count: INTEGER

	assert (b: BOOLEAN) is
		do
			count := count + 1
			if not b then
				io.put_string("TEST_NUMBER74 : ERROR Test # ")
				io.put_integer(count)
				io.put_string("%N")
			end
		end

end -- class TEST_NUMBER74
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
