-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class TEST_INTEGER7
	--
	-- Test of bit_test.
	--

creation {ANY}
	make

feature {ANY}
	make is
		local
			a8: INTEGER_8
		do
			assert((0xFF).bit_test(0))
			assert((0xFF).bit_test(1))
			assert((0xFF).bit_test(2))
			assert((0xFF).bit_test(3))
			assert((0xFF).bit_test(4))
			assert((0xFF).bit_test(5))
			assert((0xFF).bit_test(6))
			assert((0xFF).bit_test(7))
			a8 := 0xff
			assert(a8.bit_test(0))
			assert(a8.bit_test(1))
			assert(a8.bit_test(2))
			assert(a8.bit_test(3))
			assert(a8.bit_test(4))
			assert(a8.bit_test(5))
			assert(a8.bit_test(6))
			assert(a8.bit_test(7))
			assert((0x01).bit_test(0))
			assert((0x01).bit_test(1) = False)
			assert((0x01).bit_test(2) = False)
			assert((0x01).bit_test(3) = False)
			assert((0x01).bit_test(4) = False)
			assert((0x01).bit_test(5) = False)
			assert((0x01).bit_test(6) = False)
			assert((0x01).bit_test(7) = False)
			assert((0x02).bit_test(0) = False)
			assert((0x02).bit_test(1))
			assert((0x02).bit_test(2) = False)
			assert((0x02).bit_test(3) = False)
			assert((0x02).bit_test(4) = False)
			assert((0x02).bit_test(5) = False)
			assert((0x02).bit_test(6) = False)
			assert((0x02).bit_test(7) = False)
			assert((0x0002).bit_test(0) = False)
			assert((0x0002).bit_test(1))
			assert((0x0002).bit_test(2) = False)
			assert((0x0002).bit_test(3) = False)
			assert((0x0002).bit_test(4) = False)
			assert((0x0002).bit_test(5) = False)
			assert((0x0002).bit_test(6) = False)
			assert((0x0002).bit_test(7) = False)
			assert((0x0002).bit_test(8) = False)
			assert((0x0002).bit_test(9) = False)
			assert((0x0002).bit_test(10) = False)
			assert((0x0002).bit_test(11) = False)
			assert((0x0002).bit_test(12) = False)
			assert((0x0002).bit_test(13) = False)
			assert((0x0002).bit_test(14) = False)
			assert((0x0002).bit_test(15) = False)
			assert((0x0080).bit_test(0) = False)
			assert((0x0080).bit_test(1) = False)
			assert((0x0080).bit_test(2) = False)
			assert((0x0080).bit_test(3) = False)
			assert((0x0080).bit_test(4) = False)
			assert((0x0080).bit_test(5) = False)
			assert((0x0080).bit_test(6) = False)
			assert((0x0080).bit_test(7))
			assert((0x0080).bit_test(8) = False)
			assert((0x0080).bit_test(9) = False)
			assert((0x0080).bit_test(10) = False)
			assert((0x0080).bit_test(11) = False)
			assert((0x0080).bit_test(12) = False)
			assert((0x0080).bit_test(13) = False)
			assert((0x0080).bit_test(14) = False)
			assert((0x0080).bit_test(15) = False)
			assert((0x8000).bit_test(0) = False)
			assert((0x8000).bit_test(1) = False)
			assert((0x8000).bit_test(2) = False)
			assert((0x8000).bit_test(3) = False)
			assert((0x8000).bit_test(4) = False)
			assert((0x8000).bit_test(5) = False)
			assert((0x8000).bit_test(6) = False)
			assert((0x8000).bit_test(7) = False)
			assert((0x8000).bit_test(8) = False)
			assert((0x8000).bit_test(9) = False)
			assert((0x8000).bit_test(10) = False)
			assert((0x8000).bit_test(11) = False)
			assert((0x8000).bit_test(12) = False)
			assert((0x8000).bit_test(13) = False)
			assert((0x8000).bit_test(14) = False)
			assert((0x8000).bit_test(15))
		end

	assert (b: BOOLEAN) is
		do
			cpt := cpt + 1
			if not b then
				sedb_breakpoint
				std_output.put_string("TEST_INTEGER7: ERROR Test # ")
				std_output.put_integer(cpt)
				std_output.put_string("%N")
			end
		end

	cpt: INTEGER

end -- class TEST_INTEGER7
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
