-- See the Copyright notice at the end of this file.
--
expanded class HASH_TABLE_SIZE
	--
	-- Some useful features to deal with prime INTEGER values in order to
	-- select an appropriate size for some hash table (used for example
	-- by the DICTIONARY class as well as by the SET class).
	--

feature {ANY}
	prime_number_ceiling (integer: INTEGER): INTEGER is
			-- A good prime number, large enough, and no smaller than `integer'.
		do
			if integer <= 11 then
				-- This seems to be a good minimum value to start hashing with.
				Result := 11
			elseif integer <= 23 then
				Result := 23
			elseif integer <= 53 then
				Result := 53
			elseif integer <= 97 then
				Result := 97
			elseif integer <= 193 then
				Result := 193
			elseif integer <= 389 then
				Result := 389
			elseif integer <= 769 then
				Result := 769
			elseif integer <= 1543 then
				Result := 1543
			elseif integer <= 3079 then
				Result := 3079
			elseif integer <= 6151 then
				Result := 6151
			elseif integer <= 12289 then
				Result := 12289
			elseif integer <= 24593 then
				Result := 24593
			elseif integer <= 49157 then
				Result := 49157
			elseif integer <= 98317 then
				Result := 98317
			elseif integer <= 196613 then
				Result := 196613
			elseif integer <= 393241 then
				Result := 393241
			elseif integer <= 786433 then
				Result := 786433
			elseif integer <= 1572869 then
				Result := 1572869
			elseif integer <= 3145739 then
				Result := 3145739
			elseif integer <= 6291469 then
				Result := 6291469
			elseif integer <= 12582917 then
				Result := 12582917
			elseif integer <= 25165843 then
				Result := 25165843
			elseif integer <= 50331653 then
				Result := 50331653
			elseif integer <= 100663319 then
				Result := 100663319
			elseif integer <= 201326611 then
				Result := 201326611
			elseif integer <= 402653189 then
				Result := 402653189
			elseif integer <= 805306457 then
				Result := 805306457
			else
				Result := 1610612741 -- This should be enough !
			end
		ensure
			Result >= integer
		end

end -- class HASH_TABLE_SIZE
--
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- This file is part of the SmartEiffel standard library.
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
