-- See the Copyright notice at the end of this file.
--
class WORDS_OUTPUT_STREAM

inherit
	FILTER_OUTPUT_STREAM
		redefine disconnect
		end

creation {ANY}
	make

feature {ANY}
	width: INTEGER
			-- The width of the "screen"

	disconnect is
		do
			if not word.is_empty then
				flush_word
			elseif not spaces.is_empty then
				stream.put_string(spaces)
				spaces.clear_count
			end
			Precursor
		end

feature {FILTER_OUTPUT_STREAM}
	filtered_put_character (c: CHARACTER) is
		do
			if c.is_separator then
				flush_word
				spaces.extend(c)
			else
				word.extend(c)
			end
		end

	filtered_flush is
			-- '''Note''': can be dangerous because it does not take word boundaries into account!
		do
			flush_word
		end

feature {}
	local_can_disconnect: BOOLEAN is True

feature {ANY}
	make (a_width: like width) is
		require
			a_width > 0
			not is_connected
		do
			if word = Void then
				create word.make_empty
				create spaces.make_empty
			end
			width := a_width
		ensure
			width = a_width
		end

feature {}
	word: STRING

	spaces: STRING

	pos: INTEGER

	flush_word is
		require
			is_connected
		local
			i: INTEGER; c: CHARACTER
		do
			if not word.is_empty then
				if pos + spaces.count + word.count < width then
					from
						i := spaces.lower
					until
						i > spaces.upper
					loop
						c := spaces.item(i)
						check
							c.is_separator
						end
						if c = '%N' then
							pos := 0
						else
							pos := pos + 1
						end
						stream.put_character(c)
						i := i + 1
					end
				else
					stream.put_new_line
					pos := 0
				end
				stream.put_string(word)
				pos := pos + word.count
				spaces.clear_count
				word.clear_count
			end
		end

invariant
	width > 0

end -- class WORDS_OUTPUT_STREAM
--
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- This file is part of the SmartEiffel standard library.
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
