package SliMP3::Buttons::Synchronize;

# $Id: Synchronize.pm,v 1.14 2003/06/30 23:42:07 blackketter Exp $

# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License, 
# version 2.

use strict;
use File::Spec::Functions qw(:ALL);
use File::Spec::Functions qw(updir);
use SliMP3::Strings qw(string);
use SliMP3::Display;

# Each button on the remote has a function:
my %functions = (
	'up' => sub  {
			my $client = shift;
			$client->syncSelection(SliMP3::Buttons::Common::scroll($client,-1,scalar(@{$client->syncSelections}),$client->syncSelection));
			SliMP3::Display::update($client);
	},
	'down' => sub {
		my $client = shift;
		$client->syncSelection(SliMP3::Buttons::Common::scroll($client,1,scalar(@{$client->syncSelections}),$client->syncSelection));
		SliMP3::Display::update($client);
	},
	'left' => sub {
		my $client = shift;
		SliMP3::Buttons::Common::popModeRight($client);
	},
	'right' => sub  {
		my $client = shift;
		
		my $selectedClient = $client->syncSelections($client->syncSelection);
	
		my @oldlines = SliMP3::Display::curLines($client);
	
		if (SliMP3::Playlist::isSyncedWith($client, $selectedClient) || ($client eq $selectedClient)) {
			SliMP3::Playlist::unsync($client);
		} else {
			SliMP3::Playlist::sync($client, $selectedClient);
		}
		SliMP3::Animation::pushLeft($client, @oldlines, SliMP3::Display::curLines($client));
	}
);

sub getFunctions {
	return \%functions;
}

sub setMode {
	my $client = shift;

	$client->lines(\&lines);
}

sub loadList {
	my $client = shift;
	
	@{$client->syncSelections} = SliMP3::Playlist::canSyncWith($client);
	
	# add ourselves (for unsyncing) if we're already part of a synced.
	if (SliMP3::Playlist::isSynced($client)) { push @{$client->syncSelections}, $client };

	if (!defined($client->syncSelection()) || $client->syncSelection >= @{$client->syncSelections}) {
		$client->syncSelection(0);
	}
}

sub lines {
	my $client=shift;
	my $line1;
	my $line2;
	my $symbol = undef;

	loadList($client);
	
	if (scalar @{$client->syncSelections} < 1) {
		warn "Can't sync without somebody to sync with!";
		SliMP3::Buttons::Common::popMode($client);
	} else {
			# get the currently selected client
			my $selectedClient = $client->syncSelections($client->syncSelection);
			
			if (SliMP3::Playlist::isSyncedWith($client, $selectedClient) || $selectedClient eq $client) {
				$line1 = SliMP3::Strings::string('UNSYNC_WITH');
			} else {
				$line1 = SliMP3::Strings::string('SYNC_WITH');
			}
			
			my @buddies = ();
			
			foreach my $buddy (SliMP3::Playlist::syncedWith($selectedClient)) {
				if ($buddy ne $client) {
					push @buddies, $buddy;	
				}
			}
			
			if ($selectedClient ne $client) {
				push @buddies, $selectedClient;
			}
			
			while (scalar(@buddies) > 2) {
				my $buddy = pop @buddies;
				$line2 .= SliMP3::Client::name($buddy) . ", ";
			}
			
			if (scalar(@buddies) > 1) {
				my $buddy = pop @buddies;
				$line2 .= SliMP3::Client::name($buddy) . " " . SliMP3::Strings::string('AND') . " ";		
			}
			
			$line2 .= SliMP3::Client::name(pop @buddies);
	}
	return ($line1, $line2, undef, SliMP3::VFD::symbol('rightarrow'));
}

1;

__END__
