% This script simply imports the Gtk module and checks for the existence
% of a few symbols.  It does not need to connect to a windowing system
% such as X11, nor does it require TESS.  

$1 = "..";
$2 = path_concat($1,"src");
$3 = path_concat($1,"packages");
$4 = path_concat($1,"gif");

set_slang_load_path ( sprintf("%s:%s:%s:%s",$2,$3,$4, get_slang_load_path()));
set_import_module_path ( sprintf("%s:%s:%s",$1,$4, get_import_module_path()));

putenv("SLGTK_NO_DISPLAY=value_can_be_anything");
import("gtk");

private define checkfor(thing,kind)
{
   if (is_defined(thing) == kind) return;
   switch(kind)
   { case 1:  kind = "a callable intrinsic function"; }
   { case 2:  kind = "a callable S-Lang function"; }
   { case -1: kind = "an intrinsic variable"; }
   { case -2: kind = "an S-Lang variable"; }
   verror("ERROR: %s is undefined, but should be %s!", thing, kind);
}

variable ifuncs = [
   "gtk_window_new",
   "gtk_widget_show",
   "gtk_widget_show_all",
   "gtk_widget_destroy",
   "gtk_main",
   "gtk_main_quit",
   "gtk_container_add",
   "gdk_pixbuf_new_from_file",
   "g_signal_connect",
   "g_signal_connect_swapped",
   "g_object_set_data",
   "g_object_get_data",
   "gdk_gc_new"
];

variable ivars = [
   "GTK_WINDOW_TOPLEVEL",
   "GTK_POLICY_AUTOMATIC",
   "GTK_EXPAND",
   "GTK_FILL",
   "GTK_STOCK_OPEN",
   "GDK_POINTER_MOTION_MASK",
   "GDK_LEFT_PTR",
   "GDK_CROSSHAIR",
   "GDK_Delete",
   "GDK_BackSpace"
];

array_map(Void_Type, &checkfor, ifuncs, 1);
array_map(Void_Type, &checkfor, ivars, -1);
