
require("gtkplot");
require("wdisplay");		% convenience script in ../packages directory

static variable window = NULL;

define create_plot(test)
{
   variable imsize = 512;
   variable image = [1:imsize*imsize];
   variable pd = _gtk_plot_image(image);
   variable x = [1:imsize];

   _gtk_oplot(pd, x, x^3, gdk_red);
   _gtk_plot_set_labels(pd, "X", "Y = X^3");

   variable label = gtk_label_new(NULL);
   gtk_label_set_markup(label,
	 "<span foreground=\"blue\" size=\"100\" style=\"italic\">"+
	 "<b>This demo shows a curve overplotted onto an image</b>\n</span>"+
	 "<span foreground=\"red\" size=\"smaller\" face=\"times\">"+
	 "<b>Both the plot and its labels may be interactively\n</b></span>"+
	 "<span foreground=\"green\" size=\"150\" face=\"helvetica\">"+
	 "manipulated or printed.  This annotation shows how\n</span>"+
	 "<span foreground=\"purple\" underline=\"single\">"+
	 "<tt>multiple fonts, styles, and colors may be used,</tt>\n</span>\n"+
	 "<span foreground=\"yellow\">including foreign languages, like\n\n"+
	 "Chinese (<span lang=\"zh-tw\">\345\205\203\346\260\243        \351\226\213\347\231\274</span>),\n\n"+
	 "Russian (\320\227\320\264\321\200\320\260\320\262\321\201\321\202\320\262\321\203\320\271\321\202\320\265!),\n\n"+
	 "or Arabic (\330\247\331\204\330\263\331\204\330\247\331\205 \330\271\331\204\331\212\331\203\331\205)</span>\n\n\n"+
	 "<span foreground=\"blue\">"+
	 "\t\tThis background image is a simple gradient,\n"+
	 "\t\tspecified as a S-Lang array of pixel values.\n"+
	 "\t\tA variety of other image formats may also be\n"+
	 "\t\tused (FITS, JPEG, PNG, etc), provided they\n"+
	 "\t\tmay be loaded as either a GdkPixbuf or an\n"+
	 "\t\tS-Lang array.</span>");

   gtk_fixed_put(pd.canvas, label, 70, 70);

   wdisplay(pd.canvas, "Print", &_gtk_plot_print, pd, 1);
}
