static variable window = NULL;

define create_labels (test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	() = g_signal_connect(window,"destroy",&gtk_widget_destroyed,&window);

	gtk_window_set_title (window, "Label");
	variable main_vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add ( window, main_vbox);

	variable hbox = gtk_hbox_new (FALSE, 5);
	gtk_container_add ( main_vbox, hbox);

	variable vbox = gtk_vbox_new (FALSE, 5);
	gtk_box_pack_start ( hbox, vbox, FALSE, FALSE, 0);
	gtk_container_set_border_width ( window, 5);

	variable frame = gtk_frame_new ("Normal Label");
	variable label = gtk_label_new ("This is a Normal label");
	gtk_container_add ( frame, label);
	gtk_box_pack_start ( vbox, frame, FALSE, FALSE, 0);

	frame = gtk_frame_new ("Multi-line Label");
	label = gtk_label_new ("This is a Multi-line label.\n"+
	      				"Second line\nThird line");
	gtk_container_add (frame,label);
	gtk_box_pack_start (vbox,frame,FALSE,FALSE,0);

	frame = gtk_frame_new ("Left Justified Label");
	label = gtk_label_new ("This is a Left-Justified\n"+
	    				"Multi-line label.\nThird      line");
	gtk_label_set_justify (label, GTK_JUSTIFY_LEFT);
	gtk_container_add ( frame, label);
	gtk_box_pack_start ( vbox, frame, FALSE, FALSE, 0);

	frame = gtk_frame_new ("Right Justified Label");
	label = gtk_label_new ("This is a Right-Justified\n"+
	    			"Multi-line label.\nFourth line, (j/k)");
	gtk_label_set_justify (label, GTK_JUSTIFY_RIGHT);
	gtk_container_add ( frame, label);
	gtk_box_pack_start ( vbox, frame, FALSE, FALSE, 0);

	frame = gtk_frame_new ("Internationalized Label");
	label = gtk_label_new (NULL);
	gtk_label_set_markup (label,
			    "French (Fran\303\247ais) Bonjour, Salut\n"+
			    "Korean (\355\225\234\352\270\200)   \354\225\210\353\205\225\355\225\230\354\204\270\354\232\224, \354\225\210\353\205\225\355\225\230\354\213\255\353\213\210\352\271\214\n"+
			    "Russian (\320\240\321\203\321\201\321\201\320\272\320\270\320\271) \320\227\320\264\321\200\320\260\320\262\321\201\321\202\320\262\321\203\320\271\321\202\320\265!\n"+
			    "Chinese (Simplified) <span lang=\"zh-cn\">\345\205\203\346\260\224	\345\274\200\345\217\221</span>\n"+
			    "Chinese (Traditional) <span lang=\"zh-tw\">\345\205\203\346\260\243	\351\226\213\347\231\274</span>\n"+
			    "Japanese <span lang=\"ja\">\345\205\203\346\260\227	\351\226\213\347\231\272</span>\n"+
	"Greek <span lang=\"el\">\316\273\316\273\316\267\316\275\316\271\316\272\316\254)</span>");
	gtk_label_set_justify (label, GTK_JUSTIFY_LEFT);
	gtk_container_add (frame, label);
	gtk_box_pack_start (vbox, frame, FALSE, FALSE, 0);

	frame = gtk_frame_new ("Bidirection Label");
	label = gtk_label_new ("Arabic	\330\247\331\204\330\263\331\204\330\247\331\205 \330\271\331\204\331\212\331\203\331\205\n"+
			     "Hebrew	\327\251\327\234\327\225\327\235");
	gtk_widget_set_direction (label, GTK_TEXT_DIR_RTL);
	gtk_label_set_justify (label, GTK_JUSTIFY_RIGHT);
	gtk_container_add (frame, label);
	gtk_box_pack_start (vbox, frame, FALSE, FALSE, 0);


	vbox = gtk_vbox_new (FALSE, 5);
	gtk_box_pack_start ( hbox, vbox, FALSE, FALSE, 0);
	frame = gtk_frame_new ("Line wrapped label");
	label = gtk_label_new ("This is an example of a line-wrapped label."+
		"It should not be taking "+
		"up the entire             "+
		"width allocated to it, but automatically wraps the words "+
		"to fit.  The time has come, for all good men, to come to "+
		"the aid of their party.  "+
		"The sixth sheik's six sheep's sick.\n"+
		"     It supports multiple paragraphs correctly, and"+
		"correctly   adds "+ "many          extra  spaces. ");

	gtk_label_set_line_wrap (label, TRUE);
	gtk_container_add ( frame, label);
	gtk_box_pack_start ( vbox, frame, FALSE, FALSE, 0);

	frame = gtk_frame_new ("Filled, wrapped label");
	label = gtk_label_new ("This is an example of a line-wrapped, filled "+
		"label.  It should be taking "+
		"up the entire              width allocated to it.  Here is"+
		"a seneance to prove "+
		"my point.  Here is another sentence. "+
		"Here comes the sun, do de do de do.\n"+
		"    This is a new paragraph.\n"+
		"    This is another newer, longer, better paragraph."+
		"It is coming to an end, unfortunately.");

	gtk_label_set_justify (label, GTK_JUSTIFY_FILL);
	gtk_label_set_line_wrap (label, TRUE);
	gtk_container_add ( frame, label);
	gtk_box_pack_start ( vbox, frame, FALSE, FALSE, 0);

        frame = gtk_frame_new ("Underlined label");
	label = gtk_label_new ("This one is underlined (\343\201\223\343\202\223\343\201\253\343\201\241\343\201\257) in quite a funky fashion");

	gtk_label_set_justify (label, GTK_JUSTIFY_LEFT);
	gtk_label_set_pattern (label, "_________________________ _ _________ _ _____ _ __ __  ___ ____ _____");

	gtk_container_add ( frame, label);
	gtk_box_pack_start ( vbox, frame, FALSE, FALSE, 0);


	frame = gtk_frame_new ("Markup label");
	label = gtk_label_new (NULL);
	gtk_label_set_markup_with_mnemonic (label,
		"This <span foreground=\"blue\" background=\"orange\">"+
		"label</span> has <b>markup</b> _such as "+
		"<big><i>Big Italics</i></big>\n"+
		"<tt>Monospace font</tt>\n"+
		"<u>Underline!</u>\n"+
		"foo\n"+
		"<span foreground=\"green\" background=\"red\">"+
		"Ugly colors</span>\n"+
		"and nothing on this line,\nor this.\n"+
		"or this either\nor even on this one\n"+
		"la <big>la <big>la <big>la <big>la</big></big></big></big>\n"+
		"but this _word is <span foreground=\"purple\"><big>purple"+
		"</big></span>\n"+
		"<span underline=\"double\">We like <sup>superscript</sup>"+
		"and <sub>subscript</sub> too</span>");

	gtk_container_add (frame, label);
	gtk_box_pack_start (vbox, frame, FALSE, FALSE, 0);

	test.lower = generic_close_button(main_vbox,window);
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
