# Script for compiling afflib
# as part of The Sleuth Kit
#
#
# $Date: 2007/03/29 20:41:55 $
#
#
# This does not use '..' to jump out of the afflib dir
# so that afflib can be a symlink

if (test -f './afflib/Makefile') then
    true
else
    (cd afflib; touch Makefile.am && \
     touch configure.ac && \
     touch aclocal.m4 && \
     touch Makefile.in && \
     touch config.h.in && \
     touch configure) || (exit $?)
    (cd afflib; ./configure --enable-s3=no --enable-libewf=no --enable-fuse=no) || (exit $?)
fi

(cd afflib; make -C lib) || (exit $?)

if (test -f 'afflib/lib/libafflib.a') then 
    mkdir afflib-tsk
    if (test -d 'afflib-tsk') then
	cp afflib/lib/libafflib.a afflib-tsk
	(cd afflib-tsk; ar x libafflib.a; cd ..)
	ar rv ../lib/libtsk.a afflib-tsk/*.o
	rm -rf afflib-tsk
    else
	echo "Error creating tmp directory in afflib"
	exit 1
    fi
else
    echo "Error: Missing afflib/lib/libafflib.a file"
    exit 1
fi
