#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <fcntl.h>
#include "/usr/include/netinet/in.h"

#ifndef SO_REUSEPORT
#  define SO_REUSEPORT SO_REUSEADDR
#endif

int socket_CreateSocketAndConnectByDNS(char* hostname, int port) {
  struct sockaddr_in serverAddress;
  int fd = socket(PF_INET, SOCK_STREAM, 0);
  if(fd == -1) return -1;

  struct hostent *anaddr = gethostbyname(hostname);
  if(anaddr == NULL)
    fprintf(stderr, "name lookup failed %s\n", hostname);

  memset(&serverAddress, 0, sizeof(serverAddress));
  serverAddress.sin_family = AF_INET;
  serverAddress.sin_port = htons(port);
  serverAddress.sin_addr.s_addr = * (int*) (anaddr->h_addr_list[0]);

  int result = connect(fd, (struct sockaddr*) &serverAddress, sizeof(serverAddress));
  if(result != 0)
    {
      perror("connect failed");
      return -1;
    }
  fprintf(stderr, "returning %i\n", fd);
  return fd;
}

int socket_CreateSocketAndConnectByIP(int address, int port) {
  struct sockaddr_in serverAddress;
  int fd = socket(PF_INET, SOCK_STREAM, 0);
  if(fd == -1) return -1;

  memset(&serverAddress, 0, sizeof(serverAddress));
  serverAddress.sin_family = AF_INET;
  serverAddress.sin_port = htons(port);
  serverAddress.sin_addr.s_addr = address;

  fprintf(stderr, "address is %lx\n", address);
  int result = connect(fd, (struct sockaddr*) &serverAddress, sizeof(serverAddress));
  if(result != 0)
    {
      perror("connect failed");
      return -1;
    }
  fprintf(stderr, "returning %i\n", fd);
  return fd;
}

int socket_CreateSocketAndConnect(int ipaddress, int port) {

  struct sockaddr_in serverAddress;
  int fd = socket(PF_INET, SOCK_STREAM, 0);
  if(fd == -1) return -1;

  struct hostent *anaddr = gethostbyname("127.0.0.1");
  fprintf(stderr, "address is %lx\n", * (int*) (anaddr->h_addr_list[0]));

  memset(&serverAddress, 0, sizeof(serverAddress));
  serverAddress.sin_family = AF_INET;
  serverAddress.sin_port = htons(port);
  serverAddress.sin_addr.s_addr = ipaddress;

  fprintf(stderr, "in call to CreateSocket ip is %lx %lx port %i\n", ipaddress, htonl(ipaddress), port);

  int result = connect(fd, (struct sockaddr*) &serverAddress, sizeof(serverAddress));
  if(result != 0)
    {
      perror("connect failed");
      return -1;
    }
  fprintf(stderr, "returning %i\n", fd);
  return fd;
}

int socket_BindToPort(int handle, int port) {
  struct sockaddr_in serverAddress;

  serverAddress.sin_family = AF_INET;
  serverAddress.sin_addr.s_addr = htonl(INADDR_ANY);
  serverAddress.sin_port = htons(port);

  return bind(handle, (struct sockaddr *)&serverAddress, sizeof(serverAddress));
}

int socket_ListenForConnections(int handle, int backlog) {
  return listen(handle, (backlog == 0 ? SOMAXCONN : backlog));
}

int socket_AcceptConnection(int handle) {
  struct sockaddr_in client_address;
  int len;
  return accept(handle, (struct sockaddr *)&client_address, &len);
}

int socket_ReadIntoByteArray(int count, int handle, char* array, int start) {
  int numread = 0;
  while (numread < count) {
    int rc = read(handle, array + start + numread, (count - numread));
    if(rc < 0) return rc;
    numread += rc;
  }
  return numread;
}

int socket_WriteFromByteArray(int count, int handle, char* array, int start) {
  int numwritten = 0;
  while (numwritten < count) {
    int rc = write(handle, array + start + numwritten, (count - numwritten));
    if(rc < 0) return rc;
    numwritten += rc;
  }
  return numwritten;
}

int socket_DisableBlocking(int handle) {
  return fcntl(handle, F_SETFL, O_NONBLOCK);
}

int socket_CloseSocket(int handle) {
  return close(handle);
}

#define MAX_HANDLESETS 32

static fd_set HandleSets[MAX_HANDLESETS];
static int num_HandleSets = 0;

int socket_HandleSetNew() {
  if (num_HandleSets == MAX_HANDLESETS) return -1;
  return num_HandleSets++;
}

int socket_HandleSetClear(int set) {
  if (set >= num_HandleSets) return -1;
  FD_ZERO(&HandleSets[set]); return 0;
}

int unixsocket_HandleSetDelete(int set) {
  if (set >= num_HandleSets || num_HandleSets == 0) return -1;
  FD_ZERO(&HandleSets[set]);
  return num_HandleSets--;
}

int socket_HandleSetIncludes(int set, int fd) {
  return (set < num_HandleSets) ? FD_ISSET(fd, &HandleSets[set]) : -1;
}

int socket_HandleSetAdd(int set, int fd) {
  if (set >= num_HandleSets) return -1;
  FD_SET(fd, &HandleSets[set]); return 0;
}

int socket_HandleSetRemove(int set, int fd) {
  if (set < num_HandleSets) return -1;
  FD_CLR(fd, &HandleSets[set]); return 0;
}

int socket_SelectHandles(int count, int rset, int wset, int next) {
  //  int select(int numfds, fd_set *readfds, fd_set *writefds,
  //       fd_set *exceptfds, struct timeval *timeout);
  if (rset >= num_HandleSets || wset >= num_HandleSets) return -1;
  struct timeval timeout;
  timeout.tv_sec = next / 1000;
  timeout.tv_usec = next % 1000 * 1000;
  return select(count, &HandleSets[rset], &HandleSets[wset], NULL, &timeout);
}

int socket_SetOption(int handle, int flag1, int flag2) {
  int yes = 1;
  return setsockopt(handle, flag1, flag2, (char *)&yes, sizeof yes);
}

int socket_SetAddressReuse(int handle) {
  return socket_SetOption(handle, SOL_SOCKET, SO_REUSEADDR);
}

int socket_SetPortReuse(int handle) {
  return socket_SetOption(handle, SOL_SOCKET, SO_REUSEPORT);
}

int socket_SetKeepAlive(int handle) {
  return socket_SetOption(handle, SOL_SOCKET, SO_KEEPALIVE);
}

/*
int socket_SetTCPNoDelay(int handle) {
  return socket_SetOption(handle, IPPROTO_TCP, TCP_NODELAY);
}

int socket_PeerName(int handle, char* array, int count) {
  struct sockaddr peerAddress;
  if (getpeername(handle,
        (struct sockaddr *)&peerAddress,
        sizeof(peerAddress)) < 0) {
    
  }
}
*/
