#include "platform.h"

struct utsname info;

int slate_RefreshSystemInfo() {
  // Run uname() to initialize the info struct if needed.
  // Answer whether uname() worked; should mean the data is there and valid.
  return !(&info || uname(&info));
}

char* slate_GetSystemName() {
  if (slate_RefreshSystemInfo()) {
    return info.nodename;
  } else {
    return NULL;
  }
}

char* slate_GetSystemRelease() {
  if (slate_RefreshSystemInfo()) {
    return info.release;
  } else {
    return NULL;
  }
}

char* slate_GetSystemVersion() {
  if (slate_RefreshSystemInfo()) {
    return info.version;
  } else {
    return NULL;
  }
}

char* slate_GetPlatform() {
#ifdef PLATFORM
  return PLATFORM;
#else
  if (slate_RefreshSystemInfo()) {
    return info.sysname;
  } else {
    return NULL;
  }
#endif
}

char* slate_GetMachine() {
  if (slate_RefreshSystemInfo()) {
    return info.machine;
  } else {
    return NULL;
  }
}
