#include <windows.h>
#include "directory.h"
#include "file.h"
#include "slatevm.h"

static HANDLE dirs [SLATE_FILES_MAXIMUM];

void initDirectoryModule ()
{
	memset(dirs, 0, sizeof(dirs));
}

int
allocateDirectory (void)
{
	int dir;

	for (dir = 0; dir < SLATE_FILES_MAXIMUM; ++ dir)
	{
		if (dirs [dir] == 0)
			return dir;
	}

	return -1;
}

int
closeDirectory (int dir)
{
	if (dirs [dir] != 0)
	{
		CloseHandle(dirs [dir]);

		dirs [dir] = 0;
	}

        return 0;
}

int
openDirectory (struct ByteArray * name)
{
	return -1;
}

int
getCurrentDirectory (struct ByteArray * result)
{
	return GetCurrentDirectory (PSObject_payloadSize ((struct Object *) result), result -> elements);
}

int
setCurrentDirectory (struct ByteArray * path)
{
	char pathString[SLATE_PATH_NAME_LENGTH];
	int pathLength = extractCString (path, pathString, sizeof(pathString));

	if (pathLength < 0)
		return -1;

	return SetCurrentDirectory (pathString);
}

int
readDirectory (int dirHandle, struct ByteArray * buffer)
{
        return -1;
}

