#ifndef __SLATE_H__
#define __SLATE_H__

#include <stdlib.h>
#include <sys/types.h>

#include "env.h"

struct ObjectHeap;
struct ByteArray;

extern const unsigned long int CardSize;
extern unsigned long long int currentDispatchID;

void     growMemoryBy (struct ObjectHeap * heap, unsigned long int delta);
void     shrinkMemoryBy (struct ObjectHeap * heap, unsigned long int delta);
int  extractCString (struct ByteArray * array, char * buffer, size_t bufferSize);
void     error (const char * message, ...);

int		slateMain (int argc, char ** argv);

#ifndef PLATFORM
#define PLATFORM "unknown"
#endif

#endif /* __SLATE_H__ */
