#ifndef __SLATE_FILE_H__
#define __SLATE_FILE_H__

#include <stdio.h>

#include "env.h"

#define SLATE_FILES_MAXIMUM		256
#define SLATE_PATH_NAME_LENGTH	2048
#define SLATE_FILE_NAME_LENGTH	512

#define SF_READ				1
#define SF_WRITE			1 << 1
#define SF_CREATE			1 << 2
#define SF_CLEAR			1 << 3

struct ByteArray;

extern void initFileModule ();
extern void closeFile (int);
extern int openFile (struct ByteArray * name, int flags);
extern int writeFile (int, int, char *);
extern int readFile (int, int, char *);
extern int sizeOfFile (int);
extern int seekFile (int, int);
extern int tellFile (int);
//TODO: should be Bool from slatevm.h
extern int endOfFile (int);
extern int saveImageNamed (struct ByteArray *);

#endif /* __SLATE_FILE_H__ */


