#ifndef __SLATE_EXTPRIM_H__
#define __SLATE_EXTPRIM_H__

/**
 * Dynamically-loaded primitives module for Slate.
 *
 * Open issues:
 *  - win32 (natch)
 **/

enum ArgFormat
{
  ARG_FORMAT_VOID = (0 << 1) | 1,
  ARG_FORMAT_INT = (1 << 1) | 1,
  ARG_FORMAT_FLOAT = (2 << 1) | 1,
  ARG_FORMAT_POINTER = (3 << 1) | 1,
  ARG_FORMAT_BYTES = (4 << 1) | 1,
  ARG_FORMAT_BOOLEAN = (5 << 1) | 1,
  ARG_FORMAT_CSTRING = (6 << 1) | 1,
  ARG_FORMAT_C_STRUCT_VALUE = (7 << 1) | 1,
  ARG_FORMAT_DOUBLE = (8 << 1) | 1,
};

enum CallFormat
{
  CALL_FORMAT_C = (0 << 1) | 1,
  CALL_FORMAT_STD = (1 << 1) | 1,
};

struct ByteArray;
struct OopArray;

#define Bool unsigned long int
#define ObjectPointer unsigned long int

extern Bool openExternalLibrary(struct ByteArray *libname, struct ByteArray *handle);
extern Bool closeExternalLibrary(struct ByteArray *handle);
extern Bool lookupExternalLibraryPrimitive(struct ByteArray *handle,
                 struct ByteArray *symname,
                 struct ByteArray *ptr);
extern ObjectPointer applyExternalLibraryPrimitive(struct ByteArray *ptr,
                                                  struct OopArray *argsFormat,
                                                  ObjectPointer callFormat,
                                                  ObjectPointer resultFormat,
                    struct OopArray *args);

#undef ObjectPointer
#undef Bool

#endif /* __SLATE_EXTPRIM_H__ */
