#include "env.h"
#include "slatevm.h"
#include "extprim.h"

#ifndef WINDOWS
#  define __stdcall
#endif

typedef unsigned (* ext_fn0_t) (void);
typedef unsigned (* ext_fn1_t) (unsigned);
typedef unsigned (* ext_fn2_t) (unsigned, unsigned);
typedef unsigned (* ext_fn3_t) (unsigned, unsigned, unsigned);
typedef unsigned (* ext_fn4_t) (unsigned, unsigned, unsigned, unsigned);
typedef unsigned (* ext_fn5_t) (unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (* ext_fn6_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (* ext_fn7_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (* ext_fn8_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (* ext_fn9_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (* ext_fn10_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (* ext_fn11_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (* ext_fn12_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);

typedef unsigned (__stdcall * ext_std_fn0_t) (void);
typedef unsigned (__stdcall * ext_std_fn1_t) (unsigned);
typedef unsigned (__stdcall * ext_std_fn2_t) (unsigned, unsigned);
typedef unsigned (__stdcall * ext_std_fn3_t) (unsigned, unsigned, unsigned);
typedef unsigned (__stdcall * ext_std_fn4_t) (unsigned, unsigned, unsigned, unsigned);
typedef unsigned (__stdcall * ext_std_fn5_t) (unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (__stdcall * ext_std_fn6_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (__stdcall * ext_std_fn7_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (__stdcall * ext_std_fn8_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (__stdcall * ext_std_fn9_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (__stdcall * ext_std_fn10_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (__stdcall * ext_std_fn11_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);
typedef unsigned (__stdcall * ext_std_fn12_t) (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);

#define MAX_ARG_COUNT 12

ObjectPointer applyExternalLibraryPrimitive (
   struct ByteArray * fnHandle, 
   struct OopArray * argsFormat, 
   ObjectPointer callFormat,
   ObjectPointer resultFormat, 
   struct OopArray * argsArr)
{
  ext_fn0_t fn;
  unsigned args [MAX_ARG_COUNT]; 
  unsigned result;
  unsigned arg, argCount, outArgIndex = 0, outArgCount;

  assert (PSObject_payloadSize ((struct Object *) fnHandle) >= sizeof (fn));
  memcpy (& fn, fnHandle -> elements, sizeof (fn));
  
  argCount = PSObject_arraySize ((struct Object *) argsArr);
  outArgCount = argCount;
  if (argCount > MAX_ARG_COUNT || argCount != PSObject_arraySize ((struct Object *) argsFormat))
    return CurrentMemory -> NilObject;

  for (arg = 0; arg < argCount; ++arg)
  {
    ObjectPointer element = argsArr -> elements [arg];

    switch (argsFormat -> elements [arg])
    {
    case ARG_FORMAT_INT:
      if (ObjectPointer_isSmallInt (element))
        args[outArgIndex++] = (unsigned) ObjectPointer_asSmallInt (element);
      else
        args[outArgIndex++] = * (unsigned *) PSObject_arrayElements (ObjectPointer_pointer (element));
      break;
    case ARG_FORMAT_BOOLEAN:
      if (element == CurrentMemory -> TrueObject)
        args[outArgIndex++] = True;
      else // TODO check for FalseObject, signal error
        args[outArgIndex++] = False;
      break;
    case ARG_FORMAT_FLOAT:
      if (ObjectPointer_isSmallInt (element))
      {
        union {
          float f;
          unsigned u;
        } convert;
        convert.f = (float) ObjectPointer_asSmallInt (element);
        args[outArgIndex++] = convert.u;
      }
      else
        args[outArgIndex++] = * (unsigned *) PSObject_arrayElements (ObjectPointer_pointer (element));
      break;
    case ARG_FORMAT_DOUBLE:
      {
        union {
          double d;
          unsigned u [2];
        } convert;
        if (ObjectPointer_isSmallInt (element))
          convert.d = (double) ObjectPointer_asSmallInt (element);
        else
          convert.d = (double) * (float *) PSObject_arrayElements (ObjectPointer_pointer (element));
        args[outArgIndex++] = convert.u[0];
        args[outArgIndex++] = convert.u[1];
      }
      break;
    case ARG_FORMAT_POINTER:
      if (element == CurrentMemory -> NilObject)
        args[outArgIndex++] = (unsigned) NULL;
      else
        args[outArgIndex++] = * (unsigned *) PSObject_arrayElements (ObjectPointer_pointer (element));
      break;
    case ARG_FORMAT_CSTRING:
      if (element == CurrentMemory -> NilObject)
        args[outArgIndex++] = (unsigned) NULL;
      else
      {
        size_t len = PSObject_payloadSize ((struct Object *) element) + 1;
        struct Object *bufferObject = PSObjectHeap_newByteArray_sized_ (CurrentMemory, ByteArrayProto, len);
        char *buffer = (char *) PSObject_arrayElements (bufferObject);

        memcpy(buffer, (char *) PSObject_arrayElements ((struct Object *) element), len - 1);
        buffer[len] = '\0';
        args[outArgIndex++] = (unsigned) buffer;
      }
      break;
    case ARG_FORMAT_BYTES:
      if (element == CurrentMemory -> NilObject)
        args[outArgIndex++] = (unsigned) NULL;
      else
        args[outArgIndex++] = (unsigned) PSObject_arrayElements (ObjectPointer_pointer (element));
      break;
    case ARG_FORMAT_C_STRUCT_VALUE:
      {
        int length = PSObject_payloadSize ((struct Object *) element) / sizeof(void *);
        unsigned *source = (unsigned *) PSObject_arrayElements (ObjectPointer_pointer (element));
        int i;

        //make sure we have enough space
        if (argCount - arg + length > MAX_ARG_COUNT)
          return CurrentMemory -> NilObject;

        for(i = 0; i < length; ++i)
        {
          args[outArgIndex++] = source[i];
        }
        outArgCount += length - 1;
      }
      break;
    default:
      return CurrentMemory -> NilObject;
    }
  }

  if(callFormat == CALL_FORMAT_C)
  {
    switch(outArgCount)
    {
    case 0:
        result = (* (ext_fn0_t) fn) ();
        break;
    case 1:
        result = (* (ext_fn1_t) fn) (args [0]);
        break;
    case 2:
        result = (* (ext_fn2_t) fn) (args [0], args [1]);
        break;
    case 3:
        result = (* (ext_fn3_t) fn) (args [0], args [1], args [2]);
        break;
    case 4:
        result = (* (ext_fn4_t) fn) (args [0], args [1], args [2], args [3]);
        break;
    case 5:
        result = (* (ext_fn5_t) fn) (args [0], args [1], args [2], args [3], args [4]);
        break;
    case 6:
        result = (* (ext_fn6_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5]);
        break;
    case 7:
        result = (* (ext_fn7_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6]);
        break;
    case 8:
        result = (* (ext_fn8_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6], args [7]);
        break;
    case 9:
        result = (* (ext_fn9_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6], args [7], args [8]);
        break;
    case 10:
        result = (* (ext_fn10_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6], args [7], args [8], args [9]);
        break;
    case 11:
        result = (* (ext_fn11_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6], args [7], args [8], args [9], args [10]);
        break;
    case 12:
        result = (* (ext_fn12_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6], args [7], args [8], args [9], args [10], args [11]);
        break;
    default:
        return CurrentMemory -> NilObject;
    }
  }
  else if(callFormat == CALL_FORMAT_STD)
  {
    switch(outArgCount)
    {
    case 0:
        result = (* (ext_std_fn0_t) fn) ();
        break;
    case 1:
        result = (* (ext_std_fn1_t) fn) (args [0]);
        break;
    case 2:
        result = (* (ext_std_fn2_t) fn) (args [0], args [1]);
        break;
    case 3:
        result = (* (ext_std_fn3_t) fn) (args [0], args [1], args [2]);
        break;
    case 4:
        result = (* (ext_std_fn4_t) fn) (args [0], args [1], args [2], args [3]);
        break;
    case 5:
        result = (* (ext_std_fn5_t) fn) (args [0], args [1], args [2], args [3], args [4]);
        break;
    case 6:
        result = (* (ext_std_fn6_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5]);
        break;
    case 7:
        result = (* (ext_std_fn7_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6]);
        break;
    case 8:
        result = (* (ext_std_fn8_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6], args [7]);
        break;
    case 9:
        result = (* (ext_std_fn9_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6], args [7], args [8]);
        break;
    case 10:
        result = (* (ext_std_fn10_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6], args [7], args [8], args [9]);
        break;
    case 11:
        result = (* (ext_std_fn11_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6], args [7], args [8], args [9], args [10]);
        break;
    case 12:
        result = (* (ext_std_fn12_t) fn) (args [0], args [1], args [2], args [3], args [4], args [5], args [6], args [7], args [8], args [9], args [10], args [11]);
        break;
    default:
        return CurrentMemory -> NilObject;
    }
  }
  else
    return CurrentMemory -> NilObject;

  switch (resultFormat)
  {
  case ARG_FORMAT_INT:
    if (signedLongInt_fitsSmallInt (result))
      return unsignedLongInt_asObject (result);
    else
      return PSObject_asObject ((struct Object *) PSObjectHeap_newByteArray_from_sized_ (CurrentMemory, ByteArrayProto, (Byte *) & result, sizeof (result)));
  case ARG_FORMAT_BOOLEAN:
    if (result)
      return CurrentMemory -> TrueObject;
    else
      return CurrentMemory -> FalseObject;
  case ARG_FORMAT_POINTER:
    if (result == (unsigned) NULL)
      return CurrentMemory -> NilObject;
    else
      return PSObject_asObject ((struct Object *) PSObjectHeap_newByteArray_from_sized_ (CurrentMemory, ByteArrayProto, (Byte *) & result, sizeof (result)));
  case ARG_FORMAT_CSTRING:
    if (result == (unsigned) NULL)
      return CurrentMemory -> NilObject;
    else // TODO this assumes here that String's contents are ASCII bytes
      return PSObject_asObject ((struct Object *) PSObjectHeap_newByteArray_from_sized_ (CurrentMemory, StringProto, (Byte *) result, strlen ((char *) result)));
  default:
    return CurrentMemory -> NilObject;
  }
}

