#include "beosdir.h"

#include <Directory.h>
#include <cstring>


#define DIRS_MAXIMUM 256

static BDirectory *dirs[DIRS_MAXIMUM];


extern "C" void
initDirectoryModule(void)
{
	memset(dirs, 0, sizeof(dirs));
}


static int
findDirectorySlot(void)
{
	for (int i = 0; i < DIRS_MAXIMUM; i++)
		if (dirs[i] == NULL)
			return i;
	
	return B_NO_MORE_FDS;
}


extern "C" int
beosOpenDirectory(const char *name)
{
	int dirHandle = findDirectorySlot();
	if (dirHandle < 0)
		return dirHandle;
	
	dirs[dirHandle] = new BDirectory(name);
	
	if (dirs[dirHandle] == NULL)
		return B_ERROR;
	
	int check = dirs[dirHandle]->InitCheck();
	if (check != B_OK) {
		closeDirectory(dirHandle);
		return check;
	}
	
	return dirHandle;
}


extern "C" int
closeDirectory(int dirHandle)
{
	if (dirs[dirHandle] != NULL) {
		delete dirs[dirHandle];
		dirs[dirHandle] = NULL;
		return 0;
	} else
		return B_BAD_VALUE;
}


extern "C" int
beosReadDirectory(int dirHandle, struct dirent *ent)
{
	return dirs[dirHandle]->GetNextDirents(ent, sizeof(dirent));
}
