# This file should contain definitions that are common for all Makefile's

.PHONY: clean all default

OS = $(shell uname -s)

ifeq ($(OS),Darwin)
  LIBTOOL = MACOSX_DEPLOYMENT_TARGET=10.3 glibtool
else
  LIBTOOL ?= libtool
endif

ifeq (CYGWIN,$(findstring CYGWIN,$(OS)))
  # non-devel version of libtool is broken on Cygwin
  LIBTOOL_DEVEL ?= /usr/autotool/devel/bin/libtool
  ifeq ($(LIBTOOL_DEVEL),$(wildcard $(LIBTOOL_DEVEL)))
    LIBTOOL = $(LIBTOOL_DEVEL)
  else
    $(warning !!! If libtool fails with 'invalid number of)
    $(warning !!! arguments', install package libtool-devel)
  endif
  LDFLAGS += -no-undefined
  LIBS = -lm
  LN = cp -f
else
  LN = ln -s -f
  ifeq ($(OS),DragonFly)
    LIBS=-lm
  else
    ifeq ($(OS),NetBSD)
      LIBS=-lm
    else
      ifeq ($(OS),FreeBSD)
        LIBS=-lm
      else
        ifeq (MINGW,$(findstring MINGW, $(OS)))
          LIBS=-lm
        else
          LIBS=-lm -ldl
        endif
      endif
    endif
  endif
endif

CC=gcc
CFLAGS=$(COPTFLAGS) -I${slateroot}/src/mobius/vm/platform/includes -I. -I${slateroot}
COPTFLAGS=-O2 -fomit-frame-pointer -DNDEBUG=1 -s
LDFLAGS+=-avoid-version

prefix=/usr
exec_prefix=$(prefix)/bin
execname=slate
lispdir=$(prefix)/share/emacs/site-lisp
includedir=$(prefix)/include
datadir=$(prefix)/share/slate

CFLAGS+=-DSLATE_DATADIR=\"$(datadir)\"
