/* Simulator for the Renesas (formerly Hitachi) / SuperH Inc. SH architecture.

   Written by Steve Chamberlain of Cygnus Support.
   sac@cygnus.com

   This file is part of SH sim


		THIS SOFTWARE IS NOT COPYRIGHTED

   Cygnus offers the following for use in the public domain.  Cygnus
   makes no warranty with regard to the software or it's performance
   and the user accepts the software "AS IS" with all faults.

   CYGNUS DISCLAIMS ANY WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO
   THIS SOFTWARE INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

*/


#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif


#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#ifdef HAVE_LIBREADLINE
#include <readline/readline.h>
#endif

#include "coldfire.h"
#include "skyeye_config.h"
char Run_Exit = 0;

TRACER_DEFAULT_CHANNEL(run);

static int stop_now = 0;


void coldfire_init_state(){
	static int done = 0;
	if(!done){
		done = 1;
		Memory_Init();	
		Instruction_Init();
		instruction_register_instructions();
		memory_module_setup_segment("ram",0,0x0,16*1024*1024);
	}
	
}
void coldfire_reset_state(){
}

/* Execute a single instruction.  */

void
coldfire_step_once ()
{
	unsigned int Instr;
	struct _Instruction *InstructionPtr;
#ifdef INSTRUCTION_PROFILE        
	unsigned long long LowTime=0, HighTime=0;
	char Buffer[16];
#endif        
	extern struct _board_data board_data;

	//while(!Run_Exit) {
	if(1){

		 TRACE("New cycle, PC=0x%08lx, SP=0x%08lx\n",
                                memory_core.pc, memory_core.a[7]);
		printf("New cycle, PC=0x%08lx, SP=0x%08lx\n",
                                memory_core.pc, memory_core.a[7]);	
		/* Check for any pending exceptions */
		//exception_check_and_handle();
		/* As we're coming back from an interrupt, check for exit */
		//if(Run_Exit) break;

		/* Save the PC for the beginning of this instruction
		 *  This is useful for exceptions that reset the PC */
		memory_core.pc_instruction_begin = memory_core.pc;

		/* Before we execute this instruction, catch a bad PC counter */

		/* Get the instruction from memory */
		if(!Memory_RetrWord(&Instr, memory_core.pc)) 
			//continue;
			;

		/* Look it up */
		InstructionPtr = Instruction_FindInstruction(Instr);

                if(InstructionPtr==NULL) {
                        //exception_do_exception(4);
			//continue;
                } else {
                        /* Run the instruction */


			(*InstructionPtr->FunctionPtr)();

		}
		/* Now update anything that could cause an interrupt, so we
		 * can catch it in the next cycle */

		/* Call this, which will call an update
		 * for things like the UARTs and Timers */
		//memory_update();
	}
}
static void coldfire_set_pc(WORD addr){
	memory_core.pc = addr; 
}
//chy 2006-04-14 maybe changed in the future !!!???
static int
coldfire_ICE_write_byte (WORD addr, uint8_t v)
{
	Memory_StorByte(addr,v);
	return 0;
}
static int 
coldfire_ICE_read_byte(WORD addr, uint8_t *pv){
	unsigned int v;
	int res;
	res=Memory_RetrByte(&v, addr);
	if (res==1){ //success
		*pv=(unsigned char)v;
		return 0; //fault=0
	}else{
		return 1;//fault=1
	}
}
static int
coldfire_parse_cpu (cpu_config_t * cpu, const char *param[])
{
}


static int
coldfire_parse_mach (machine_config_t * cpu, const char *param[])
{
	
}

static int coldfire_parse_mem(int num_params, const char *params[]){
	//memory_module_setup_segment("ram",0,0x0,0x400000);	
}

void init_coldfire_arch(){
	static arch_config_t coldfire_arch;

	coldfire_arch.arch_name = "coldfire";
        //coldfire_arch.pc = 0;
        coldfire_arch.init = coldfire_init_state;
        coldfire_arch.reset = coldfire_reset_state;
        coldfire_arch.set_pc = coldfire_set_pc;
        coldfire_arch.step_once = coldfire_step_once;
        coldfire_arch.ICE_write_byte = coldfire_ICE_write_byte;
	coldfire_arch.ICE_read_byte = coldfire_ICE_read_byte;
        coldfire_arch.parse_cpu = coldfire_parse_cpu;
        coldfire_arch.parse_mach = coldfire_parse_mach;
        coldfire_arch.parse_mem = NULL;

        register_arch (&coldfire_arch);

}
