#!/bin/bash

sikulirun()
{
    rm "${IN}/.all_plugins.skg.wrk" > /dev/null 2>&1
    # start sikuli
    killall skrooge > /dev/null 2>&1
    # generate filename for logfile
    mkdir -p "${OUT}/${1}" > /dev/null 2>&1
    LOGFILE="${OUT}/${1}/sikuliresult.txt"

    type runsikulix > /dev/null 2>&1
    rc=$?
    if [ $rc != 0 ] ; then
        echo "[WARNING]: runsikulix not found"
        echo "Please install it and add it in PATH"
        echo "You can find it here: http://www.sikuli.org/"
        rc=0
    else	
        runsikulix -r "${TESTDIR}/sikuli/$1.sikuli" > "$LOGFILE" 2>&1
        rc=$?
        if [ $rc = 0 ] ; then
            grep "\[error\]" "$LOGFILE"
            a=$?
            if [ $a = 0 ] ; then
                rc=99
            fi
        fi
        if [ $rc != 0 ] ; then
            echo "sikuli execution error:"$rc
            cat "$LOGFILE"
        else
            #check output
            rc=0
        fi
    fi
    killall skrooge > /dev/null 2>&1
    return $rc
}

checkDiff()
{
    echo "##checkDiff"
    diff "$1" "$2" > /tmp/diff.txt 2>&1
    rc=$?
    if [ $rc != 0 ] ; then
        echo "##diff $1 $2"
        cat /tmp/diff.txt
        echo "##FAILED"
        exit $rc
    else
        echo "##SUCCEEDED"
    fi
}

#initialisation
unset LANG
export TESTDIR="/data/skrooge-release_2.15.0/skrooge-2.15.0/tests"
export IN="${TESTDIR}/input/"
export OUT="${TESTDIR}/output/"
export REF="${TESTDIR}/ref/"
export KDEHOME="${IN}kde/"
export LC_ALL=C
export XDG_DATA_HOME="${KDEHOME}xdg/local/"
export XDG_CONFIG_HOME="${KDEHOME}/xdg/config/"

export SKGNOTUNIQUE=1

rm -Rf "${KDEHOME}" > /dev/null 2>&1

mkdir -p "${OUT}/${EXE}" > /dev/null 2>&1
EXEPATH="/data/skrooge-release_2.15.0/skrooge-2.15.0/build/bin"
LIBPATH="/data/skrooge-release_2.15.0/skrooge-2.15.0/build/lib"

if [ "$TERM" = "cygwin" ] ; then
  export EXE=${EXE}.exe
fi
if [ "$TERM" = "msys" ] ; then
    export EXE=${EXE}.exe
    export EXEPATH=`echo "$EXEPATH" | sed -e "s,C:,/c/,g"`
    export LIBPATH=`echo "$LIBPATH" | sed -e "s,C:,/c/,g"`
fi

export EXE="/data/skrooge-release_2.15.0/skrooge-2.15.0/build/bin/"${EXE}
export PATH="$EXEPATH":"$LIBPATH":$PATH

#kbuildsycoca4

#echos
echo "KDE directory      =${KDEHOME}"
echo "Input directory    =${IN}"
echo "Output directory   =${OUT}"
echo "Reference directory=${REF}"
echo "PATH               =${PATH}"
echo "EXE                =${EXE}"
