/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGREFUNDPLUGINWIDGET_H
#define SKGREFUNDPLUGINWIDGET_H
/** @file
 * A skrooge plugin to follow refund
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgrefundpluginwidget_base.h"
#include "skgtabwidget.h"

class SKGObjectModel;

/**
 * A skrooge plugin to follow refund
 */
class SKGRefundPluginWidget : public SKGTabWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGRefundPluginWidget(SKGMainPanel* iParent, SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGRefundPluginWidget();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Get attribute name to save the default state
         * MUST BE OVERWRITTEN
         * @return attribute name to save the default state.
         */
        virtual QString getDefaultStateAttibute();

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

        /**
         * Get the current selection
         * @return selected objects
         */
        virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

        /**
         * Get the number of seleted object
         * @return number of selected objects
         */
        virtual int getNbSelectedObjects();

private slots:
        void dataModified(const QString& iTableName, int iIdTransaction);
        void onDoubleClick();
        void onSelectionChanged();
        void onEditorModified();
        void onAddTracker();
        void onModifyTracker();
        void onFilterChanged();
        void onFilterRegExpChanged();

private:
        Q_DISABLE_COPY(SKGRefundPluginWidget);

        Ui::skgrefundplugin_base ui;
        SKGObjectModel* objectModel;
};

#endif // SKGREFUNDPLUGINWIDGET_H
