/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for delete operation.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgdeleteplugin.h"
#include "skgtraces.h"
#include "skgerror.h"
#include "skgobjectbase.h"
#include "skgtransactionmng.h"
#include "skgmainpanel.h"

#include <QtGui/QWidget>

#include <kactioncollection.h>
#include <kstandardaction.h>

K_PLUGIN_FACTORY(SKGDeletePluginFactory, registerPlugin<SKGDeletePlugin>();)
K_EXPORT_PLUGIN(SKGDeletePluginFactory("skrooge_delete", "skrooge_delete"))

SKGDeletePlugin::SKGDeletePlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
        SKGTRACEIN(10, "SKGDeletePlugin::SKGDeletePlugin");
}

SKGDeletePlugin::~SKGDeletePlugin()
{
        SKGTRACEIN(10, "SKGDeletePlugin::~SKGDeletePlugin");
        parent=NULL;
        currentBankDocument=NULL;
        deleteAction=NULL;
}

void SKGDeletePlugin::setupActions(SKGMainPanel* iParent, SKGDocument* iDocument, const QStringList& iArgument)
{
        SKGTRACEIN(10, "SKGDeletePlugin::setupActions");
        Q_UNUSED(iArgument);

        currentBankDocument=iDocument;
        parent=iParent;

        setComponentData( SKGDeletePluginFactory::componentData() );
        setXMLFile("skrooge_delete.rc");

        //Menu
        deleteAction = new KAction(KIcon("edit-delete"), i18n("&Delete"), this);
        connect(deleteAction, SIGNAL(triggered(bool)), this, SLOT(actionDelete()));
        actionCollection()->addAction( QLatin1String("edit_delete"), deleteAction );
        deleteAction->setShortcut(Qt::Key_Delete);

        if (parent) parent->registedGlobalAction("edit_delete", deleteAction);
}

void SKGDeletePlugin::refresh()
{
        SKGTRACEIN(10, "SKGDeletePlugin::refresh");
        if (deleteAction && parent) deleteAction->setEnabled(parent->getSelectedObjects().count()>0);
}

QString SKGDeletePlugin::title() const
{
        return i18n("Delete");
}

QString SKGDeletePlugin::icon() const
{
        return "";
}

QString SKGDeletePlugin::statusTip () const
{
        return i18n("Delete");
}

QString SKGDeletePlugin::toolTip () const
{
        return i18n("Delete");
}

int SKGDeletePlugin::getOrder() const
{
        return 5;
}

void SKGDeletePlugin::close()
{
        SKGTRACEIN(10, "SKGDeletePlugin::close");
}

void SKGDeletePlugin::actionDelete()
{
        SKGError err;
        SKGTRACEINRC(10, "SKGDeletePlugin::actionDelete",err);

        QApplication::setOverrideCursor(QCursor(Qt::WaitCursor));
        if (parent && currentBankDocument) {
                SKGObjectBase::SKGListSKGObjectBase selection=parent->getSelectedObjects();
                int nb=selection.count();
                SKGBEGINPROGRESSTRANSACTION(*currentBankDocument, i18n("Delete"), err, nb);
                for (int i=0; err.isSucceeded() && i<nb; ++i) {
                        err=selection[i].remove();
                        if (err.isSucceeded()) err=currentBankDocument->stepForward(i+1);
                }

                //status bar
                if (err.isSucceeded()) err=SKGError(0, i18n("Objects deleted."));
                else err.addError(ERR_FAIL, i18n("Delete failed"));
        }
        QApplication::restoreOverrideCursor();

        //Display error
        if (parent) parent->displayErrorMessage(err);
}

#include "skgdeleteplugin.moc"
