/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGTABLEWITHGRAPH_H
#define SKGTABLEWITHGRAPH_H
/** @file
 * A table with graph for skrooge.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include "ui_skgtablewithgraph.h"
#include "skgservices.h"

#include <kglobal.h>
#include <QWidget>
#include <QtDesigner/QDesignerExportWidget>

class SKGGraphicsScene;
class KMenu;

/**
 * This file is a table with graph for skrooge
 */
class KDE_EXPORT SKGTableWithGraph : public QWidget
{
        Q_OBJECT
        Q_PROPERTY( QString state READ getState WRITE setState)

public:
        /**
         * Default Constructor
         * @param parent the parent
         */
        SKGTableWithGraph(QWidget *parent = 0);

        /**
         * Default Destructor
         */
        virtual ~SKGTableWithGraph();

        /**
        * Get the current state
        * MUST BE OVERWRITTEN
        * @return a string containing all information needed to set the same state.
        * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Returns the table.
         * @return vertical table
         */
        virtual QTableWidget* table() const;

        /**
         * Set Data
         * @param iData the data
         * @param iPrimaryUnit the primary unit
         * @param iSecondaryUnit the secondary unit
         * @param iSecondaryUnitValue the secondary unit value
         * @param iShowSumAndAverage show sum and average columns
         */
        virtual void setData(const SKGStringListList& iData,
                             const QString& iPrimaryUnit,
                             const QString& iSecondaryUnit,
                             double iSecondaryUnitValue,
                             bool iShowSumAndAverage=true);

        /**
         * Get the table content
         * @return the table content
         */
        virtual SKGStringListList getTable();

        /**
         * Get a pointer on the contextual menu of the table
         * @return contextual menu
         */
        virtual KMenu* getTableContextualMenu() const;

        /**
         * Get a pointer on the contextual menu of the graph
         * @return contextual menu
         */
        virtual KMenu* getGraphContextualMenu() const;

signals:
        /**
         * Emitted when a cell is double clicked
         * @param row row of the cell
         * @param column column of the cell
         */
        void cellDoubleClicked(int row, int column);

public slots:
private slots:
        void onExportTXT();
        void onExportCSV();
        void onSelectionChanged(QTableWidgetItem* current, QTableWidgetItem* previous);
        void onSelectionChangedInGraph();
        void onDoubleClick(int row, int column);
        void onDoubleClickGraph();
        void onFilterModified();
        void onOneLevelMore();
        void onOneLevelLess();
        void refresh();
        void redrawGraph();
        void showMenu(const QPoint& pos);
private:
        Q_DISABLE_COPY(SKGTableWithGraph);

        double computeStepSize( double iRange, double iTargetSteps );
        void addArrow(const QPointF& iPeak, double iSize, double iArrowAngle=45, double iDegree=90);

        static bool listSort(const QStringList &s1, const QStringList &s2);
        static Qt::SortOrder sortOrder;
        static int sortColumn;


        Ui::skgtablewithgraph_base ui;
        SKGGraphicsScene* scene;
        int nbLevel;

        SKGStringListList data;
        QString primaryUnit;
        QString secondaryUnit;
        double secondaryUnitValue;
        bool showSumAndAverage;

        KMenu* mainMenu;
};

#endif // SKGTABLEWITHGRAPH_H
