/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A table view for skrooge (qt designer plugin).
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtableviewdesignerplugin.h"
#include "skgtableview.h"

#include "kicon.h"

#include <QtPlugin>

SKGTableViewDesignerPlugin::SKGTableViewDesignerPlugin(QObject *parent)
                : QObject(parent)
{
        initialized = false;
}

void SKGTableViewDesignerPlugin::initialize(QDesignerFormEditorInterface * /* core */)
{
        if (initialized) return;

        initialized = true;
}

bool SKGTableViewDesignerPlugin::isInitialized() const
{
        return initialized;
}

QWidget *SKGTableViewDesignerPlugin::createWidget(QWidget *parent)
{
        return new SKGTableView(parent);
}

QString SKGTableViewDesignerPlugin::name() const
{
        return "SKGTableView";
}

QString SKGTableViewDesignerPlugin::group() const
{
        return "SKG Widgets";
}

QIcon SKGTableViewDesignerPlugin::icon() const
{
        return KIcon("skrooge.png");
}

QString SKGTableViewDesignerPlugin::toolTip() const
{
        return "A table view used by skrooge";
}

QString SKGTableViewDesignerPlugin::whatsThis() const
{
        return "A table view used by skrooge";
}

bool SKGTableViewDesignerPlugin::isContainer() const
{
        return true;
}

QString SKGTableViewDesignerPlugin::domXml() const
{
        return "<widget class=\"SKGTableView\" name=\"SKGTableView\">\n"
               " <property name=\"geometry\">\n"
               "  <rect>\n"
               "   <x>0</x>\n"
               "   <y>0</y>\n"
               "   <width>100</width>\n"
               "   <height>100</height>\n"
               "  </rect>\n"
               " </property>\n"
               "</widget>\n";
}

QString SKGTableViewDesignerPlugin::includeFile() const
{
        return "skgtableview.h";
}

