/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGREFUNDTRACKEROBJECT_H
#define SKGREFUNDTRACKEROBJECT_H
/** @file
 * This file is part of Skrooge and defines classes SKGRefundTrackerObject.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include "skgnamedobject.h"

class SKGDocumentBank;

/**
 * This class manages refund tracker object
 */
class KDE_EXPORT SKGRefundTrackerObject : public SKGNamedObject
{
        Q_OBJECT;

public:
        /**
         * Constructor
         * @param iDocument the document containing the object
         * @param iID the identifier in @p iTable of the object
         */
        explicit SKGRefundTrackerObject(const SKGDocument* iDocument=NULL, int iID=0);

        /**
         * Copy constructor
         * @param iObject the object to copy
         */
        SKGRefundTrackerObject(const SKGRefundTrackerObject& iObject);

        /**
         * Copy constructor
         * @param iObject the object to copy
         */
        SKGRefundTrackerObject(const SKGObjectBase& iObject);

        /**
         * Operator affectation
         * @param iObject the object to copy
         */
        virtual const SKGRefundTrackerObject& operator= (const SKGObjectBase& iObject);

        /**
         * Destructor
         */
        virtual ~SKGRefundTrackerObject();

        /**
         * Create a refund if needed and return it
         * @param iDocument the document where to create
         * @param iName the name
         * @param oRefund the refund
         * @param iSendPopupMessageOnCreation to send a creation message if the refund is created
         * @return an object managing the error.
         *   @see SKGError
         */
        static SKGError createRefund(const SKGDocumentBank* iDocument,
                                     const QString& iName,
                                     SKGRefundTrackerObject& oRefund,
                                     bool iSendPopupMessageOnCreation=false);
        /**
         * Get all suboperations of this refund tracker
         * @param oSubOperations all suboperations of this operation
         * @return an object managing the error
         *   @see SKGError
         */
        virtual SKGError getSubOperations(SKGListSKGObjectBase& oSubOperations) const;

        /**
         * Set the comment of refund tracker
         * @param iComment the comment
         * @return an object managing the error
         *   @see SKGError
         */
        virtual SKGError setComment(const QString& iComment);

        /**
         * Get the comment of this refund tracker
         * @return the comment
         */
        virtual QString getComment() const;

        /**
         * To set the closed attribute of this refund tracker
         * @param iClosed the closed attribute: true or false
         * @return an object managing the error
         *   @see SKGError
         */
        virtual SKGError setClosed(bool iClosed);

        /**
         * To know if the refund tracker has been closed or not
         * @return an object managing the error
         *   @see SKGError
         */
        virtual bool isClosed() const;

        /**
         * Get the current amount
         * @return the current amount
         */
        virtual double getCurrentAmount() const;
};


#endif
