/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A skrooge plugin for monthlu report
 *
 * @author Stephane MANKOWSKI
 */
#include "skgmonthlyplugin.h"
#include "skgmonthlypluginwidget.h"
#include "skrooge_monthly.h"
#include "skgtraces.h"

#include <kactioncollection.h>
#include <kstandardaction.h>

K_PLUGIN_FACTORY(SKGMonthlyPluginFactory, registerPlugin<SKGMonthlyPlugin>();)
K_EXPORT_PLUGIN(SKGMonthlyPluginFactory("skrooge_monthly", "skrooge_monthly"))

SKGMonthlyPlugin::SKGMonthlyPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
        SKGTRACEIN(10, "SKGMonthlyPlugin::SKGMonthlyPlugin");
}

SKGMonthlyPlugin::~SKGMonthlyPlugin()
{
        SKGTRACEIN(10, "SKGMonthlyPlugin::~SKGMonthlyPlugin");
        parent=NULL;
        currentBankDocument=NULL;
}

void SKGMonthlyPlugin::setupActions(SKGMainPanel* iParent, SKGDocument* iDocument, const QStringList& iArgument)
{
        SKGTRACEIN(10, "SKGMonthlyPlugin::setupActions");
        Q_UNUSED(iArgument);

        currentBankDocument=iDocument;
        parent=iParent;

        setComponentData( SKGMonthlyPluginFactory::componentData() );
        setXMLFile("skrooge_monthly.rc");

        //Create yours actions here
}

void SKGMonthlyPlugin::refresh()
{
        SKGTRACEIN(10, "SKGMonthlyPlugin::refresh");
}

void SKGMonthlyPlugin::close()
{
        SKGTRACEIN(10, "SKGMonthlyPlugin::close");
}

SKGTabWidget* SKGMonthlyPlugin::getWidget()
{
        SKGTRACEIN(10, "SKGMonthlyPlugin::getWidget");
        return new SKGMonthlyPluginWidget(parent, currentBankDocument);
}

QWidget* SKGMonthlyPlugin::getPreferenceWidget()
{
        SKGTRACEIN(10, "SKGMonthlyPlugin::getPreferenceWidget");
       /* QWidget* widget=new QWidget();
        ui.setupUi(widget);
        return widget;*/
	return NULL;
}

KConfigSkeleton* SKGMonthlyPlugin::getPreferenceSkeleton()
{
        return skrooge_monthly::self();
}

SKGError SKGMonthlyPlugin::savePreferences() const
{
        return SKGError();
}

QString SKGMonthlyPlugin::title() const
{
        return i18n("Monthly report");
}

QString SKGMonthlyPlugin::icon() const
{
        return "skrooge_monthly_report";
}

QString SKGMonthlyPlugin::statusTip () const
{
        return i18n("Monthly report");
}

QString SKGMonthlyPlugin::toolTip () const
{
        return i18n("Monthly report");
}

int SKGMonthlyPlugin::getOrder() const
{
        return 50;
}

QStringList SKGMonthlyPlugin::tips() const
{
        QStringList output;
        output.push_back(i18n("<p>... you can generate a monthly report.</p>"));
        return output;
}

bool SKGMonthlyPlugin::isInContext() const
{
        return true;
}

#include "skgmonthlyplugin.moc"
