/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGTABWIDGET_H
#define SKGTABWIDGET_H
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <kglobal.h>
#include <QWidget>

#include "skgobjectbase.h"

class SKGDocument;
class SKGMainPanel;

/**
 * This file is Skrooge tab widget used by plugins
 */
class KDE_EXPORT SKGTabWidget : public QWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGTabWidget(SKGMainPanel* iParent, SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGTabWidget();

        /**
         * Get the current selection
         * MUST BE OVERWRITTEN
         * @return selected objects
         */
        virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

        /**
         * Get the number of seleted object
         * CAN BE OVERWRITTEN FOR OPTIMIZATION
         * @return number of selected objects
         */
        virtual int getNbSelectedObjects();

        /**
         * Get main panel
         * @return pointer on main panel
         */
        virtual SKGMainPanel* getMainPanel();

        /**
         * Get main document
         * @return pointer on main document
         */
        virtual SKGDocument* getDocument();

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Set the bookmark id
         * @param iId bookmark id
         */
        virtual void setBookmarkID(const QString& iId);

        /**
         * Get the bookmark id
         * @return bookmark id
         */
        virtual QString getBookmarkID();

signals:
        /**
         * This signal must be launched when the selection is modified
         */
        void selectionChanged();

public slots:
        /**
         * Closes this widget
         * @return true if the widget was closed; otherwise returns false.
         */
        virtual bool close();

private:
        Q_DISABLE_COPY(SKGTabWidget);

        SKGMainPanel* parent;
        SKGDocument*  document;
        QString       bookmarkID;
};

#endif // SKGTABWIDGET_H
