/* Public domain. */

#include "sysdeps.h"

#ifdef HASGETPEEREID
/* syscall exists - do nothing */

#else

#include "getpeereid.h"

#ifdef HASSO_PEERCRED
/* implementation with SO_PEERCRED */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

int getpeereid (int s, int *u, int *g)
{
  struct ucred dummy = { 0, 0, 0 } ;
  unsigned int len = sizeof(dummy) ;

  if (getsockopt(s, SOL_SOCKET, SO_PEERCRED, &dummy, &len) == -1)
    return -1 ;
  *u = dummy.uid ;
  *g = dummy.gid ;
  return 0 ;
}

#else
/* nonexistent getpeereid : dummy implementation */

#include <errno.h>

int getpeereid (int s, int *uid, int *gid)
{
  (void)s ;
  *uid = *gid = -1 ;
  errno = ENOSYS ;
  return -1 ;
}

#endif
#endif
