#include "sjog.h"
#include "sjog_volume.h"

/* -------------------------------------------------------------------------- */

/* Timer callback that hides the volume dialog window.
 */
int
sjog_volume_timer_callback(gpointer * data)
{
   D_ENTER;

   sjog_volume_hide();

   /* return false so that the timer won't call us back again */
   return FALSE;
}

/* -------------------------------------------------------------------------- */

/* Volume window closed callback, we hide the window instead of
 * destroying it.
 */
int
sjog_volume_signal_delete_event_callback(GtkWidget * widget, GdkEvent * event,
                                         gpointer * data)
{
   D_ENTER;

   sjog_volume_hide();

   /* return true so that the window won't be destroyed */
   return TRUE;

}
