//#define XERR
#include "loop.ih"

bool Loop::leaving(double screeningAge)
{
    xerr("natural: " << d_naturalDeathAge << ", screen age: " << screeningAge);

    if (                                        // see below
        screeningAge  <= d_naturalDeathAge
        and
        (
            not d_tumor.selfDetectable() or
            screeningAge <= d_tumor.selfDetectAge()
        )
    )
    {
        g_log << "    no natural death, no self-detectable/self-detected "
                "tumor:\n";
        return false;                       // no natural Death
    }

        // determine whether the woman died between the previous and current
        // screening rounds
    if (
        d_tumor.selfDetectable() and
            d_tumor.selfDetectAge() <= d_naturalDeathAge
    )
        intervalCancer();
    else
    {
        setStatus(LEFT_DURING, d_naturalDeathAge);

        if (not d_tumor.selfDetectable())    // a tumor was developed
            g_log << "  ** case leaves: natural death\n";
        else
        {
            g_log << "  ** case leaves: self detected tumor\n";
            d_tumor.characteristics(d_deathAge);    // d_deathAge now equal
        }                                           // to d_naturalDeathAge
    }

    return true;
}

//  negating the original condition to return false if the woman hasn't died:
//  return false if death didn't occur:
//        not (
//            d_naturalDeathAge < screeningAge
//            or
//            (d_tumor and d_tumor.selfDetectAge() < screeningAge)
//        )

//    if (d_tumor)
//    xerr("self detect age: " << d_tumor.selfDetectAge());
