//#define XERR
#include "loop.ih"

void Loop::intervalCancer()
{
    // a self-detected tumor before the next screening: an interval cancer.

    d_tumor.intervalCancer();
    ++d_nIntervals[d_round];

    d_selfDetected = true;

    d_tumor.characteristics();

        // treat the tumor and determine the death-age of the women
        // since the tumor is present, no need to call diameterCheck()
    addCost(treatmentCosts(d_tumor.selfDetectAge()));

    d_tumor.setDeathAge();

    if (d_naturalDeathAge < d_tumor.deathAge())     // natural death
    {
        g_log << "  ** intervalCancer. case leaves: natural death at age " <<
            d_naturalDeathAge << '\n';
        setStatus(LEFT_DURING, d_naturalDeathAge);
    }
    else                                            // death by tumor
    {
        g_log << "  ** intervalCancer: case leaves due to tumor at age " <<
            d_tumor.deathAge() << '\n';

        setStatus(TUMOR_DURING, d_tumor.deathAge());
    }
}
