/*
 SimpleCDR Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>
 */
#include <string>

using namespace std;

#ifndef __SIMPLECDR_H__
#define __SIMPLECDR_H__ 
struct Setup 
{
	string ripper;
	string reader;
	string readerdev;
	string recorder;
	string recorderdev;
	string speed;
	string cdrdaoburner;
	string cdrdaoreader;
	string encoder;
	string decoder;
	string tempdirdata;
	string tempdiraudio;
	string status;
	string home;
	string custom_cdrecord;
	string fifo;
	string logfilename;
	};

//All enumerted type and constant should be in uppercase 
//to distinguish them from variable 
enum RipType {RIPONLY, ENCODE, MASTER};
enum blankType {FAST, ALL};
enum imageType {ROCKRIDGE, JOLIET, ROCKNJOL}; 
enum multiType {SINGLE, FIRST, SECOND};
enum songType {MP3, OGG, WAV, NONE};
enum addType {EDIRECTORY, EDIRECTORY_CONTENTS, EFILE, ECD_TRACK, EPLAYLIST, ESAVE_PLAYLIST, ECD_IMAGE_LOAD, ECD_IMAGE_SAVE, EENCODE_FILE, EBURN_MASTERDATA, EBURN_MASTERAUDIO, EBURN_CDRDAOCOPY, EBURN_MKISOFSCOPY, EBURN_AUDIOCOPY, EBURN_AUDIOCOPYSAMEDEV, EBURN_ISO, EDIR_SEL, ECREATE_ISO, EBURN_BIN, ETOC_SEL, ECREATE_BIN, EID3_TAG, ECREATE_IMG};

#endif //__SIMPLECDR_H__
