/*
 SimpleCDR-X Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>
 */

#include "masteraudiocd.h"

using namespace std;


void MasterAudioCD::writeAudioCD(int tracks, bool simulate, bool normalize, bool dao, bool cdrdao_aud, bool overburn, Setup setupData1, string dirname)
{
   string command, sim="", daonce="", ob="", fname;
   int cont;
   
	if (simulate==true && cdrdao_aud==false)
      sim="-dummy";
   if (simulate==true && cdrdao_aud==true)
      sim="--simulate";
   if (dao==true)
      daonce="-dao";
   if(cdrdao_aud==true && overburn==true)
      ob="--overburn";
   if(cdrdao_aud==false && overburn==true)
      ob="-ignsize -overburn";
   if (normalize==true && simulate==false)
   {
      cout<<"Normalizing"<<endl;
      command="cd "+dirname+"; normalize -m track*.wav";
      cont=exec_cmd(command, setupData1);
      if (cont==1)
         return;
   }
   if (cdrdao_aud==true)
   {
      ofstream tocFile;
		fname=dirname+"/tempaud.toc";
		//cout<<fname<<endl;
		tocFile.open(fname.c_str());
		tocFile << "CD_DA"<<"\n";
		for (int i=1; i<tracks; i++)
		{
		   string suffix;
			convert.trackSuf(i, suffix);
			string filename=dirname+"/track"+suffix+".wav";
         tocFile << "TRACK AUDIO\nFILE \"" << filename << "\" 0\n\n";
	   }
      tocFile.close();
		command="cdrdao write --device "+setupData1.recorder+" --speed "+setupData1.speed+" --driver "+setupData1.cdrdaoburner+" --buffers 64 "+ob+" "+sim+" "+fname;
   }
   else
   {   
		command="cd "+dirname+"; cdrecord "+setupData1.custom_cdrecord+" "+sim+" "+ob+" fs="+setupData1.fifo+"k -v "+daonce+" -pad speed="+setupData1.speed+" dev="+setupData1.recorder+" "+setupData1.custom_cdrecord+" -audio track*.wav";
	}
    exec_cmd(command, setupData1);
   if (cdrdao_aud==true)
   	unlink(fname.c_str());
		
   command="cd "+dirname+"; rm track*.wav";
   system(command.c_str());
	rmdir(dirname.c_str());
}

//******************
int MasterAudioCD::ripNAdd(string& filename, string suffix, string track, Setup setupData1)
{
   string command;
   cout<<"Ripping track..."<<track<<endl;

   if (setupData1.ripper=="cdparanoia")
      command="cdparanoia -v -d "+setupData1.readerdev+" "+track+" "+filename;
   if (setupData1.ripper=="cdda2wav")
      command="cdda2wav -t "+track+" -H -D "+setupData1.reader+" "+filename;
         
	int cont=exec_cmd(command, setupData1);
	return cont;
}

//***********************
 
void MasterAudioCD::time_est(string filename, string& time_ind, string& time_total, songType song, int& total)
{
   string command, function, size;
   int minute=0, second=0, seconds=0; 
  
   if (song==WAV)
   {
      wav_.OpenRead(filename.c_str());
      seconds=int(wav_.GetNumSeconds());
      wav_.Close(); 
   }
  if (song==MP3)
  {
     load_mp3(filename.c_str());
     seconds=mp3_.seconds;
  }
#ifdef HAVE_VORBIS
  if (song==OGG)
     ogginfo(filename.c_str(), seconds);  
#endif //HAVE_VORBIS

#ifndef HAVE_VORBIS
   if (song==OGG)
      seconds=0;  
#endif
   if (seconds > 0)
      total=total+seconds;
    
   minute=seconds/60;
   second=seconds%60;
   convert.timeconverter(minute, "minute", time_ind);
   convert.timeconverter(second, "second", time_ind);
 
   minute=total/60;
   second=total%60;
   
   convert.timeconverter(minute, "minute", time_total);
   convert.timeconverter(second, "second", time_total);
 }

//*********************************

int MasterAudioCD::convertTracklist(int count, int tracks, string temp, Setup setupData1, string dirname)
{
   string command, filename, suffix;
   filename=temp;
   bool typeMP3=false, typeWAV=false, typeOGG=false;
   convert.trackSuf(count, suffix);

	if(filename.find(".mp3") !=-1 || filename.find(".Mp3") !=-1 || filename.find(".mP3") != -1 || filename.find(".MP3") !=-1)
		typeMP3=true;
	if(filename.find(".WAV") !=-1 || filename.find(".wav") !=-1 || filename.find(".Wav") != -1 || filename.find(".WAv") !=-1 || filename.find(".wAv") !=-1 || filename.find(".waV") != -1 || filename.find(".WaV") !=-1)
	    typeWAV=true;
	if(filename.find(".OGG") !=-1 || filename.find(".ogg") !=-1 || filename.find(".Ogg") != -1 || filename.find(".OGg") !=-1 || filename.find(".oGg") !=-1 || filename.find(".ogG") != -1 || filename.find(".OgG") !=-1)
		typeOGG=true;
	if(typeMP3==true && typeWAV==false && typeOGG==false)
	{
  	 cout<<"Converting MP3 file, track "<<count<<endl;
  	 if (setupData1.decoder=="mad")
         command="madplay -v -o WAVE:"+dirname+"/track"+suffix+".wav \""+filename+"\""; 
      if (setupData1.decoder=="lame")
         command="lame --decode \""+filename+"\" "+dirname+"/track"+suffix+".wav ";
      if (setupData1.decoder=="mpg123" || setupData1.decoder=="mpg321")
         command=setupData1.decoder+" -w "+dirname+"/track"+suffix+".wav \""+filename+"\"";
   }
   if (typeMP3==false && typeWAV==false && typeOGG==true)
	{
      cout<<"Converting OGG file, track "<<count<<endl;
      command="cd "+dirname+"; ogg123 --device=wav \""+filename+"\" -f track"+suffix+".wav ";
   } 
   if (typeMP3==false && typeWAV==true && typeOGG==false)
   {
 	  int find=filename.find("cd_track");
 	  if (find==-1)
 	     command="cp \""+filename+"\" "+dirname+"/track"+suffix+".wav";
      else
	   {
 	     cout<<"Copying WAV file, track "<<count<<endl;
 	     command="cp \""+filename+"\" "+dirname+"/track"+suffix+".wav"; 
 	  }
   }   
   int cont=exec_cmd(command, setupData1);
   return cont;
} //funtion close

//*************************************

int MasterAudioCD::load_mp3(const char *filename)
{
	memset(&mp3_,0,sizeof(mp3info));
	
	if ( !( mp3_.file=fopen(filename,"rb+") ) ) {
		return 0;
	    }

	mp3_.filename=filename;
	get_mp3_info(&mp3_,SCAN_QUICK,0);
	return 0;
}


void MasterAudioCD::time_sub(string filename, songType song, int& total)
{
   string command, function, size, type;
   int seconds=0; 
  
   if (song==WAV)
   {
      wav_.OpenRead(filename.c_str());
      seconds=int(wav_.GetNumSeconds());
      wav_.Close(); 
   }
   if (song==MP3)
   {
      load_mp3(filename.c_str());
      seconds=mp3_.seconds;
   }

#ifdef HAVE_VORBIS
   if (song==OGG)
      ogginfo(filename.c_str(), seconds);  
#endif

#ifndef HAVE_VORBIS
   if (song==OGG)
      seconds=0;  
#endif

   if (seconds > 0)
      total=total-seconds;
}

//********************************
#ifdef HAVE_VORBIS
//Excerpted from ogginfo.c, part of the vorbis-tools package of the OGG Vorbis project
void MasterAudioCD::ogginfo(const char *filename, int& seconds)
{
  FILE *fp;
  OggVorbis_File vf;
  int rc,i;
  vorbis_comment *vc;
  double playtime;
  long playmin, playsec;

  memset(&vf,0,sizeof(OggVorbis_File));
  
  fp = fopen(filename,"r");
  if (!fp) {
    fprintf(stderr,"Unable to open \"%s\": %s\n",
	    filename,
	    strerror(errno));
  }

  rc = ov_open(fp,&vf,NULL,0);

  if (rc < 0) {
    fprintf(stderr,"Unable to understand \"%s\", errorcode=%d\n",
	    filename,rc);
    return;
  }
  
  printf("filename=%s\n",filename);
  vc = ov_comment(&vf,-1);

  for (i=0; i < vc->comments; i++) {
    printf("%s\n",vc->user_comments[i]);
  }

  playtime = ov_time_total(&vf,-1);

  playmin = (long)playtime / (long)60;
  playsec = (long)playtime - (playmin*60);
  seconds = int(playtime);

//  printf("length=%f\n",playtime);
//  printf("playtime=%ld:%02ld\n",playmin,playsec);

  ov_clear(&vf);

}
#endif //HAVE_VORBIS
