### ARGs use -D[var]=[ON/OFF] or [1/0] or [true/false](see after)
### ex: cmake -Denable_java=ON -Denable_gtnets=ON ./

set(BIBTEX2HTML ${BIBTEX2HTML} CACHE PATH "Path to bibtex2html")
set(gtnets_path ${gtnets_path} CACHE PATH "Path to gtnets lib and include")
set(ns3_path ${ns3_path} CACHE PATH "Path to ns3 lib and include")
set(custom_flags ${custom_flags} CACHE FORCE "Customers flags add to cmake_c_flag")

if(NOT CMAKE_INSTALL_PREFIX)
	set(CMAKE_INSTALL_PREFIX "/usr/local/simgrid/" CACHE PATH "Path where to install project")
else(NOT CMAKE_INSTALL_PREFIX)
	set(CMAKE_INSTALL_PREFIX ${CMAKE_INSTALL_PREFIX} CACHE PATH "Path where to install project")
endif(NOT CMAKE_INSTALL_PREFIX)

set(pipol_user ${pipol_user} CACHE TYPE INTERNAL FORCE)

option(release "Whether Release Mode is activated (disable tests on experimental parts)" on)

option(enable_gtnets "Whether gtnets model is activated." off)
option(enable_ns3    "Whether ns3 model is activated." off)
option(enable_smpi "This variable set smpi lib." off)
option(enable_lua "Whether the lua bindings are activated." on)

if(WIN32 OR APPLE) 
set(enable_smpi off CACHE TYPE INTERNAL FORCE)
set(enable_lua off CACHE TYPE INTERNAL FORCE)
endif(WIN32 OR APPLE) 

option(enable_compile_optimizations "" on)
option(enable_compile_warnings "Whether compilation warnings should be turned into errors." off)
option(enable_maintainer_mode "Whether flex and flexml files should be rebuilt." off)
option(enable_supernovae "Whether Supernovae mode (helping compiler optimization) is activated." on)
option(enable_tracing "Tracing simulations for visualization." on)
option(enable_latency_bound_tracking "" off)
option(enable_coverage "Enable coverage." off)
option(enable_memcheck "Enable memcheck." off)
option(enable_print_message "Enable print message during config." off)
option(enable_model-checking "" off)
option(enable_lib_static "" off)
option(enable_jedule "Jedule output of SimDAG." off)
option(enable_debug "Set NDEBUG flag" on)

if(enable_supernovae AND enable_model-checking)
	set(enable_model-checking false CACHE TYPE INTERNAL FORCE)
	message("\n\nWith supernovae mode the model checking must be disable.!!!\n\n")
endif(enable_supernovae AND enable_model-checking)


mark_as_advanced(HAVE_SSH)
mark_as_advanced(HAVE_RSYNC)
#mark_as_advanced(enable_coverage)
#mark_as_advanced(enable_memcheck)
#mark_as_advanced(enable_print_message)
mark_as_advanced(BIBTEX2HTML_PATH)
mark_as_advanced(BUILDNAME)
mark_as_advanced(ADDR2LINE)
mark_as_advanced(BIBTOOL_PATH)
mark_as_advanced(BUILD_TESTING)
mark_as_advanced(CMAKE_BUILD_TYPE)
mark_as_advanced(DART_ROOT)
mark_as_advanced(DOXYGEN_PATH)
mark_as_advanced(FIG2DEV_PATH)
mark_as_advanced(FLEXML_EXE)
mark_as_advanced(FLEX_EXE)
mark_as_advanced(PERL_EXECUTABLE)
mark_as_advanced(GCOV_PATH)
mark_as_advanced(ICONV_PATH)
mark_as_advanced(MAKE_PATH)
mark_as_advanced(SVN)
mark_as_advanced(GIT)
mark_as_advanced(CMAKE_OSX_ARCHITECTURES)                                                                                                                  
mark_as_advanced(CMAKE_OSX_DEPLOYMENT_TARGET)                                                                                                              
mark_as_advanced(CMAKE_OSX_SYSROOT)                                                                         
mark_as_advanced(SED_EXE)
mark_as_advanced(BIBTEX2HTML)
