/* specific to Borland Compiler */
#ifdef __BORLANDC__
#pragma hdrstop
#endif

#include <stdlib.h>
#include <stdio.h>
#include "msg/msg.h"
#include <gras.h>

char *gras_log=NULL;
int client(int argc,char *argv[]);
int server(int argc,char *argv[]);

int launch_client(int argc,char *argv[]);
int launch_server(int argc,char *argv[]);
int launch_client(int argc, char **argv) {
  char **myargv=argv;
  int myargc=argc;
  int i;
  int retcode;
    
  if (gras_log) {
    myargv=malloc((argc+1) * sizeof(char**));
    for (i=0; i<argc; i++)
      myargv[i] = argv[i];
    myargv[myargc++] = gras_log;
  }
  retcode = client(myargc,myargv);
  if (myargv != argv)
    free(myargv);
  return retcode;
}
int launch_server(int argc, char **argv) {
  char **myargv=argv;
  int myargc=argc;
  int i;
  int retcode;
    
  if (gras_log) {
    myargv=malloc((argc+1) * sizeof(char**));
    for (i=0; i<argc; i++)
      myargv[i] = argv[i];
    myargv[myargc++] = gras_log;
  }
  retcode = server(myargc,myargv);
  if (myargv != argv)
    free(myargv);
  return retcode;
}
/* specific to Borland Compiler */
#ifdef __BORLANDDC__
#pragma argsused
#endif

int main (int argc,char *argv[]) {

  /*  Simulation setup */
  gras_global_init(&argc,argv);
  if (argc != 2) {
    fprintf(stderr, "Usage: lua platform_script.lua [--log=...]\n");
    exit(1);
  }


  /*  Application deployment */
  gras_function_register("client", launch_client);
  gras_function_register("server", launch_server);


  gras_load_environment_script(argv[1]);

  /*  Run the simulation */
  gras_main();

  /* cleanup the place */
  gras_clean();
  if (gras_log)
    free(gras_log);
  return 0;
}
