/* Handle Fortan - C conversion for MPI Types*/

/* Copyright (c) 2010, 2013-2017. The SimGrid Team.
 * All rights reserved.                                                     */

/* This program is free software; you can redistribute it and/or modify it
 * under the terms of the license (GNU LGPL) which comes with this package. */

#ifndef SMPI_F2C_HPP_INCLUDED
#define SMPI_F2C_HPP_INCLUDED

#include "xbt/dict.h"

#define KEY_SIZE (sizeof(int) * 2 + 1)

namespace simgrid{
namespace smpi{

class F2C {
  private:
    // We use a single lookup table for every type.
    // Beware of collisions if id in mpif.h is not unique
    static xbt_dict_t f2c_lookup_;
    static int f2c_id_;
  protected:
    static xbt_dict_t f2c_lookup();
    static void set_f2c_lookup(xbt_dict_t dict);
    static int f2c_id();
    static void f2c_id_increment();
  public:
    static char* get_key(char* key, int id);
    static char* get_key_id(char* key, int id);
    static void delete_lookup();
    static xbt_dict_t lookup();

    //Override these to handle specific values.
    int add_f();
    static void free_f(int id);
    int c2f();

    //This method should be overriden in all subclasses
    //to avoid casting the result when calling it.
    //For the default one, the MPI_*_NULL returned is assumed to be NULL.
    static F2C* f2c(int id);
};

}
}

#endif
